/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import jetbrains.youtrack.markup.extensions.CheckboxNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/markup/renderer/CheckboxRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "Lorg/commonmark/node/AbstractVisitor;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "getNodeTypes", "", "Ljava/lang/Class;", "Ljetbrains/youtrack/markup/extensions/CheckboxNode;", "render", "", "node", "Lorg/commonmark/node/Node;", "youtrack-application"})
public final class CheckboxRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final HtmlWriter html;

    @NotNull
    public Set<Class<CheckboxNode>> getNodeTypes() {
        return SetsKt.setOf(CheckboxNode.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        if (node2 instanceof CheckboxNode) {
            if (((CheckboxNode)node2).getShouldRenderAsCheckbox()) {
                this.html.raw("<label>");
                ArrayList params = CollectionsKt.arrayListOf((Object[])new Pair[]{TuplesKt.to((Object)"type", (Object)"checkbox"), TuplesKt.to((Object)"data-position", (Object)String.valueOf(((CheckboxNode)node2).getPosition()))});
                if (((CheckboxNode)node2).getChecked()) {
                    Collection collection = params;
                    Iterable iterable = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"checked", (Object)""), TuplesKt.to((Object)"type", (Object)"checkbox")});
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                }
                this.html.tag("input", MapsKt.toMap((Iterable)params));
                this.html.raw(((CheckboxNode)node2).getLabelText());
                this.html.raw("</label>");
            } else {
                this.html.text(((CheckboxNode)node2).getLiteral() + ((CheckboxNode)node2).getLabelText());
            }
        }
    }

    public CheckboxRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        HtmlWriter htmlWriter = context2.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }
}

