/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.commonmark.node.Block;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\n*\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/markup/renderer/CodeBlockNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "codeHighlighterLimit", "", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "language", "", "Lorg/commonmark/node/Node;", "getLanguage", "(Lorg/commonmark/node/Node;)Ljava/lang/String;", "getLanguageAttributeMap", "", "node", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Block;", "render", "", "renderCodeBlock", "escapeForXml", "youtrack-application"})
public final class CodeBlockNodeRenderer
implements NodeRenderer {
    private final int codeHighlighterLimit = 102400;
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<? extends Block>> getNodeTypes() {
        return SetsKt.setOf((Object[])new Class[]{FencedCodeBlock.class, IndentedCodeBlock.class});
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        this.html.line();
        this.renderCodeBlock(node2);
        this.html.line();
    }

    private final void renderCodeBlock(Node node2) {
        String string;
        Node node3 = node2;
        if (node3 instanceof IndentedCodeBlock) {
            string = ((IndentedCodeBlock)node2).getLiteral();
        } else if (node3 instanceof FencedCodeBlock) {
            string = ((FencedCodeBlock)node2).getLiteral();
        } else {
            throw (Throwable)new IllegalStateException("Don't know how to handle node type: " + node2.getClass());
        }
        String code2 = string;
        if (BeansKt.getMarkdownProcessingContext().getNoCss()) {
            this.html.tag("pre");
        } else {
            CharSequence charSequence;
            List css = CollectionsKt.mutableListOf((Object[])new String[]{"wikicode"});
            if (code2.length() < this.codeHighlighterLimit) {
                css.add("prettyprint");
            }
            if (!((charSequence = (CharSequence)this.getLanguage(node2)) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                css.add("linenums");
            }
            this.html.tag("pre", this.context.extendAttributes(node2, "pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)CollectionsKt.joinToString$default((Iterable)css, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)))));
        }
        this.html.tag("code", this.context.extendAttributes(node2, "code", this.getLanguageAttributeMap(node2)));
        String string2 = code2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"code");
        this.html.text(this.escapeForXml(string2));
        this.html.tag("/code");
        this.html.tag("/pre");
        if (!BeansKt.getMarkdownProcessingContext().getNoJs() && !BeansKt.getMarkdownProcessingContext().getNoCss()) {
            this.html.tag("script");
            this.html.text("prettyPrint();");
            this.html.tag("/script");
        }
    }

    private final Map<String, String> getLanguageAttributeMap(Node node2) {
        String language2 = this.getLanguage(node2);
        CharSequence charSequence = language2;
        return charSequence == null || charSequence.length() == 0 ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)("language-" + language2)));
    }

    private final String getLanguage(@NotNull Node $receiver) {
        Object object;
        Node node2 = $receiver;
        return node2 instanceof FencedCodeBlock ? ((object = ((FencedCodeBlock)$receiver).getInfo()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) != null ? (String)object.get(0) : null) : null;
    }

    private final String escapeForXml(@NotNull String $receiver) {
        return StringsKt.replace$default((String)$receiver, (String)"\u001b", (String)"\u25a1", (boolean)false, (int)4, null);
    }

    public CodeBlockNodeRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.codeHighlighterLimit = 102400;
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }
}

