/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/markup/renderer/ExternalLinkRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Link;", "render", "", "node", "Lorg/commonmark/node/Node;", "sanitizeHref", "", "href", "visitChildren", "parent", "youtrack-application"})
public final class ExternalLinkRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<Link>> getNodeTypes() {
        return SetsKt.setOf(Link.class);
    }

    public void render(@NotNull Node node2) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Link link = (Link)node2;
        String string = this.context.encodeUrl(link.getDestination());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.encodeUrl(link.destination)");
        String url2 = this.sanitizeHref(string);
        Map attrs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"href", (Object)url2)});
        if (!BeansKt.getMarkdownProcessingContext().getNoJs() && (charSequence = (CharSequence)url2).length() > 0) {
            String encodedUrl = URLEncoder.encode(url2, StandardCharsets.UTF_8.displayName());
            attrs.put("onclick", "return /^((?!chrome|android).)*safari/i.test(navigator.userAgent) || ((window.open(window.decodeURIComponent('" + encodedUrl + "'), '_blank').opener=null) || false);");
        }
        if (!BeansKt.getMarkdownProcessingContext().getNoCss()) {
            attrs.put("target", "_blank");
            attrs.put("rel", "noopener noreferrer");
        }
        if (link.getTitle() != null) {
            String string2 = link.getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"link.title");
            attrs.put("title", string2);
        }
        this.context.getWriter().tag("a", this.context.extendAttributes((Node)link, "a", attrs));
        this.visitChildren((Node)link);
        this.context.getWriter().tag("/a");
    }

    private final String sanitizeHref(String href) {
        String string;
        String string2 = string = href;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.startsWith$default((String)string4, (String)"javascript:", (boolean)false, (int)2, null) ? "" : href;
    }

    private final void visitChildren(Node parent2) {
        Node node2 = parent2.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNext();
            this.context.render(node2);
            node2 = next;
        }
    }

    public ExternalLinkRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }
}

