/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.filters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="corsContainerFilter")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0002R\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/rest/filters/YouTrackCORSContainerResponseFilter;", "Ljavax/ws/rs/container/ContainerResponseFilter;", "()V", "allowedOrigins", "", "", "getAllowedOrigins", "()Ljava/lang/Iterable;", "filter", "", "request", "Ljavax/ws/rs/container/ContainerRequestContext;", "response", "Ljavax/ws/rs/container/ContainerResponseContext;", "isAllowedOrigin", "", "requestOrigin", "Companion", "youtrack-application"})
public final class YouTrackCORSContainerResponseFilter
implements ContainerResponseFilter {
    private static final String ACCESS_CONTROL_HEADER = "Access-Control-Allow-Origin";
    private static final String ORIGIN_HEADER_NAME = "Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    private static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    @NotNull
    private static final ThreadLocal<Boolean> ALLOW_ALL_ORIGINS;
    public static final Companion Companion;

    private final Iterable<String> getAllowedOrigins() {
        return (Iterable)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Set<String>>(){

            public final Set<String> invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BeansKt.getRestSettings().getAllAllowedOrigins();
            }
        }), (int)7, null);
    }

    public void filter(@NotNull ContainerRequestContext request, @Nullable ContainerResponseContext response) {
        block6: {
            CharSequence charSequence;
            ContainerResponseContext containerResponseContext;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (StringsKt.equals((String)"OPTIONS", (String)request.getMethod(), (boolean)true)) {
                ContainerResponseContext containerResponseContext2 = response;
                if (containerResponseContext2 != null) {
                    containerResponseContext2.setStatusInfo((Response.StatusType)Response.Status.OK);
                }
            }
            ContainerResponseContext containerResponseContext3 = response;
            if (containerResponseContext3 == null) break block6;
            ContainerResponseContext it = containerResponseContext = containerResponseContext3;
            String requestOrigin = request.getHeaderString(ORIGIN_HEADER_NAME);
            if (Companion.allowAllOrigins() || this.isAllowedOrigin(requestOrigin)) {
                MultivaluedMap multivaluedMap = response.getHeaders();
                String string = requestOrigin;
                if (string == null) {
                    string = "*";
                }
                multivaluedMap.put((Object)ACCESS_CONTROL_HEADER, (Object)CollectionsKt.listOf((Object)string));
                response.getHeaders().put((Object)ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER, (Object)CollectionsKt.listOf((Object)true));
                String requestedHeadersToAllow = request.getHeaderString(ACCESS_CONTROL_REQUEST_HEADERS_HEADER);
                if (requestedHeadersToAllow != null && (charSequence = (CharSequence)requestedHeadersToAllow).length() > 0) {
                    response.getHeaders().put((Object)ACCESS_CONTROL_ALLOW_HEADERS_HEADER, (Object)CollectionsKt.listOf((Object)requestedHeadersToAllow));
                }
            }
            response.getHeaders().putSingle((Object)ACCESS_CONTROL_EXPOSE_HEADERS, (Object)"Location");
            String requestedMethod = request.getHeaderString(ACCESS_CONTROL_REQUEST_METHOD);
            if (requestedMethod != null && (charSequence = (CharSequence)requestedMethod).length() > 0) {
                response.getHeaders().putSingle((Object)ACCESS_CONTROL_ALLOW_METHODS, (Object)requestedMethod);
            }
        }
    }

    private final boolean isAllowedOrigin(String requestOrigin) {
        Object object;
        if (requestOrigin == null) {
            return false;
        }
        try {
            object = new URL(requestOrigin).getAuthority();
        }
        catch (MalformedURLException ignore) {
            object = Unit.INSTANCE;
        }
        Unit calculatedOrigin = object;
        Iterable<String> iterable = this.getAllowedOrigins();
        if (iterable == null) {
            return true;
        }
        Iterable<String> allowedOrigins2 = iterable;
        return CollectionsKt.contains(allowedOrigins2, (Object)calculatedOrigin);
    }

    static {
        Companion = new Companion(null);
        ACCESS_CONTROL_HEADER = ACCESS_CONTROL_HEADER;
        ORIGIN_HEADER_NAME = ORIGIN_HEADER_NAME;
        ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER;
        ACCESS_CONTROL_ALLOW_HEADERS_HEADER = ACCESS_CONTROL_ALLOW_HEADERS_HEADER;
        ACCESS_CONTROL_REQUEST_HEADERS_HEADER = ACCESS_CONTROL_REQUEST_HEADERS_HEADER;
        ACCESS_CONTROL_REQUEST_METHOD = ACCESS_CONTROL_REQUEST_METHOD;
        ACCESS_CONTROL_ALLOW_METHODS = ACCESS_CONTROL_ALLOW_METHODS;
        ACCESS_CONTROL_EXPOSE_HEADERS = ACCESS_CONTROL_EXPOSE_HEADERS;
        ALLOW_ALL_ORIGINS = new ThreadLocal();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/rest/filters/YouTrackCORSContainerResponseFilter$Companion;", "Lmu/KLogging;", "()V", "ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER", "", "ACCESS_CONTROL_ALLOW_HEADERS_HEADER", "ACCESS_CONTROL_ALLOW_METHODS", "ACCESS_CONTROL_EXPOSE_HEADERS", "ACCESS_CONTROL_HEADER", "ACCESS_CONTROL_REQUEST_HEADERS_HEADER", "ACCESS_CONTROL_REQUEST_METHOD", "ALLOW_ALL_ORIGINS", "Ljava/lang/ThreadLocal;", "", "getALLOW_ALL_ORIGINS", "()Ljava/lang/ThreadLocal;", "ORIGIN_HEADER_NAME", "allowAllOrigins", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final ThreadLocal<Boolean> getALLOW_ALL_ORIGINS() {
            return ALLOW_ALL_ORIGINS;
        }

        public final boolean allowAllOrigins() {
            return Intrinsics.areEqual((Object)Boolean.TRUE, (Object)this.getALLOW_ALL_ORIGINS().get());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

