/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scheduling;

import jetbrains.charisma.main.BeansKt;
import jetbrains.youtrack.scheduling.LocalScheduling;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\f\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/scheduling/QuartzParametersFactory;", "", "()V", "newJob", "Lorg/quartz/JobDetail;", "job", "Ljetbrains/youtrack/scheduling/LocalScheduling;", "newTrigger", "Lorg/quartz/Trigger;", "cron", "", "schedule", "Lorg/quartz/ScheduleBuilder;", "youtrack-application"})
public final class QuartzParametersFactory {
    @NotNull
    public final Trigger newTrigger(@NotNull LocalScheduling job, @NotNull String cron2) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull((Object)cron2, (String)"cron");
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression(cron2));
        Intrinsics.checkExpressionValueIsNotNull((Object)cronScheduleBuilder, (String)"CronScheduleBuilder.cron\u2026ule(CronExpression(cron))");
        return this.newTrigger(job, (ScheduleBuilder<? extends Trigger>)((ScheduleBuilder)cronScheduleBuilder));
    }

    @NotNull
    public final Trigger newTrigger(@NotNull LocalScheduling job, @NotNull ScheduleBuilder<? extends Trigger> schedule2) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull(schedule2, (String)"schedule");
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(job.getName(), BeansKt.getDomainName()).forJob(this.newJob(job)).withSchedule(schedule2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)trigger, (String)"TriggerBuilder.newTrigge\u2026\n                .build()");
        return trigger;
    }

    @NotNull
    public final JobDetail newJob(@NotNull LocalScheduling job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        JobDetail jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(job.getName(), BeansKt.getDomainName()).usingJobData(new JobDataMap(MapsKt.mapOf((Pair)TuplesKt.to((Object)"beanReference", (Object)job)))).storeDurably(false).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jobDetail, (String)"JobBuilder.newJob(job.ja\u2026\n                .build()");
        return jobDetail;
    }
}

