/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.facade;

import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.CompositeLocalizationObject;
import jetbrains.mps.internationalization.runtime.IdentityLocalizationObject;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IPrefixTrees;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.commands.facade.CommandUtil;
import jetbrains.youtrack.commands.impl.AddCommentCommandExecutor;
import jetbrains.youtrack.commands.impl.CommentCell;
import jetbrains.youtrack.commands.impl.OneCellCommand;
import jetbrains.youtrack.commands.rest.CommandRestUtil;
import org.jetbrains.annotations.NotNull;

public class CommandServiceImpl
implements CommandService {
    private static ThreadLocal<Integer> suggestLimit = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 15;
        }
    };
    private String myTemplate;

    public ICommandList parse(String command, @NotNull IContext context2) {
        return CommandUtil.parse(command, context2);
    }

    public ICommandList parse(String command, Entity issue) {
        Context context2 = new Context();
        context2.setSelectedIssues(QueryOperations.singleton((Entity)issue));
        return this.parse(command, (IContext)context2);
    }

    public String getCommandDialogTemplate() {
        return this.getTemplate();
    }

    public Iterable<String> createCommandFromIssue(Entity issue) {
        return CommandUtil.issueToCommandsFromBlank(issue);
    }

    public Iterable<Entity> decodeIssues(String issueIds) {
        return CommandRestUtil.toIssues(issueIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<SuggestItem> suggest(final ICommandList commandList2, final int caret2, final int limit) {
        suggestLimit.set(limit);
        try {
            Iterable iterable = (Iterable)((IPrefixTrees)ServiceLocator.getBean((String)"prefixTrees")).read((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<IListSequence<SuggestItem>, IPrefixTreesData>(){

                public IListSequence<SuggestItem> invoke(IPrefixTreesData data) {
                    return Sequence.fromIterable((Iterable)commandList2.getSuggestions(caret2)).take(limit).toListSequence();
                }
            });
            return iterable;
        }
        finally {
            suggestLimit.set(15);
        }
    }

    public ICommandList execute(Entity issue, String command) {
        return this.execute(issue, command, null, null, false);
    }

    public ICommandList execute(Entity issue, String command, String comment2, String groupName, boolean silent) {
        return this.execute(QueryOperations.singleton((Entity)issue), command, comment2, groupName, silent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommandList execute(Iterable<Entity> issues, String command, String comment2, String groupName, boolean silent) {
        ICommandList commandList2;
        Context context2 = new Context();
        context2.setSelectedIssues(issues);
        if (command == null || command.length() == 0) {
            command = " ";
        }
        if ((commandList2 = ((CommandService)ServiceLocator.getBean((String)"commandService")).parse(command, (IContext)context2)).hasErrors()) {
            if (commandList2.hasErrors()) {
                CompositeLocalizationObject errors = new CompositeLocalizationObject();
                IdentityLocalizationObject newLine = new IdentityLocalizationObject("\n");
                errors.append((Localization)new LocalizationObject("Issue.Command_{0}_is_invalid", new Object[]{command}));
                errors.append((Localization)newLine);
                for (ICommand cmd : Sequence.fromIterable((Iterable)commandList2.getCommands())) {
                    if (!cmd.isError()) continue;
                    errors.append((Localization)new LocalizationObject("Issue.Unknown_command_{0}", new Object[]{BaseHtmlStringUtil.html((Object)cmd.getText())}));
                    errors.append((Localization)newLine);
                }
                throw new LocalizedLogicException((Localization)errors);
            }
        } else {
            if (CommandServiceImpl.isNotEmpty_q5o17p_a0a0a0f0i(comment2 == null ? null : comment2.trim()) && !commandList2.hasDeleteIssueCommand()) {
                Entity userGroup = RestUtil.getUserGroup((String)groupName, (String)"permitted group");
                AddCommentCommandExecutor commentExecutor2 = new AddCommentCommandExecutor(comment2, QueryOperations.singleton((Entity)userGroup), null);
                commandList2.addCommand((ICommand)new OneCellCommand(commandList2, new CommentCell(), commentExecutor2));
            }
            if (silent) {
                ((EventMarker)ServiceLocator.getBean((String)"silentApplyEventMarker")).add();
            }
            try {
                commandList2.execute();
                DnqUtils.getCurrentTransientSession().flush();
            }
            finally {
                if (silent) {
                    ((EventMarker)ServiceLocator.getBean((String)"silentApplyEventMarker")).remove();
                }
            }
        }
        return commandList2;
    }

    public int getSuggestLimit() {
        return suggestLimit.get();
    }

    public String getTemplate() {
        return this.myTemplate;
    }

    public void setTemplate(String value) {
        this.myTemplate = value;
    }

    public static boolean isNotEmpty_q5o17p_a0a0a0f0i(String str) {
        return str != null && str.length() > 0;
    }
}

