/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.facade;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ICollectionSequence;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IPrefixTrees;
import jetbrains.youtrack.api.parser.IPrefixTreesData;
import jetbrains.youtrack.commands.impl.AddCommentCommandExecutor;
import jetbrains.youtrack.commands.impl.CommandsParserFactory;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class CommandUtil {
    public static int MAX_ISSUES_TO_UPDATE = 2000;
    public static int MAX_ISSUES_TO_DELETE = 1500;
    public static int MIN_ISSUES_TO_SUGGEST_SILENT = 10;
    protected static Log log = LogFactory.getLog(CommandUtil.class);

    public static ICommandList parse(String command, @NotNull IContext context2) {
        return CommandUtil.parse((IPrefixTrees)ServiceLocator.getBean((String)"prefixTrees"), command, context2);
    }

    public static ICommandList parse(IPrefixTrees keyWordBundle, final String command, final @NotNull IContext context2) {
        return (ICommandList)keyWordBundle.read((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<ICommandList, IPrefixTreesData>(){

            public ICommandList invoke(IPrefixTreesData data) {
                return CommandsParserFactory.create().parse(data, command, context2);
            }
        });
    }

    public static Iterable<ICommand> getValidCommands(ICommandList commandList2) {
        return Sequence.fromIterable((Iterable)commandList2.getCommands()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<ICommand>(){

            public boolean accept(ICommand it) {
                return !(it instanceof AddCommentCommandExecutor) && (it.getCommandExecutor() != null || it.isError());
            }
        });
    }

    public static ICommandList applyCommandToIssue(Entity issue, String command) {
        return CommandUtil.applyCommandToIssue(issue, command, true);
    }

    public static ICommandList applyCommandToIssue(Entity issue, String command, boolean flushPages) {
        Context context2 = new Context();
        context2.setSelectedIssues(QueryOperations.singleton((Entity)issue));
        ICommandList commandList2 = CommandUtil.parse(command, (IContext)context2);
        if (commandList2.hasErrors() && log.isDebugEnabled()) {
            log.debug((Object)("Can't apply command [" + command + "] for issue [" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + "]: " + commandList2.getText()));
        }
        commandList2.execute(flushPages);
        return commandList2;
    }

    public static Iterable<String> issueToCommandsFromBlank(final Entity issue) {
        ICollectionSequence multivalueCommand;
        final HashSet<String> excludedTypes = new HashSet<String>(Arrays.asList("text", "string"));
        ICollectionSequence commands = CollectionSequence.fromCollection(new ArrayList());
        final Entity loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        IListSequence customFields = Sequence.fromIterable((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getAccessibleCustomFields(loggedInUser, issue)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isWriteAccessible(issue, loggedInUser, it) && !((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).hasDefaultValue(issue, it);
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !SetSequence.fromSet((Set)excludedTypes).contains((Object)((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getType(AssociationSemantics.getToOne((Entity)it, (String)"prototype")).getValueType().toLowerCase());
            }
        }).toListSequence();
        for (Entity customField : ListSequence.fromList((List)customFields)) {
            if (((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).isMultivalue(customField)) {
                ICollectionSequence multivalueCommand2 = CollectionSequence.fromCollection(new ArrayList());
                for (String value : Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).getValuePresentation(issue, customField).split(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandUtil.", new Object[0]))))) {
                    CollectionSequence.fromCollection((Collection)multivalueCommand2).addElement((Object)((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"name", String.class, null) + " " + value));
                }
                CollectionSequence.fromCollection((Collection)commands).addElement((Object)IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand2), (String)" "));
                continue;
            }
            CollectionSequence.fromCollection((Collection)commands).addElement((Object)((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"name", String.class, null) + " " + ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)customField, (String)"ProjectCustomField")).getValueRenderer(customField).getPresentation(((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)customField, (String)"prototype"), (String)"CustomFieldPrototype")).getValue(issue, AssociationSemantics.getToOne((Entity)customField, (String)"prototype")), DetalizationLevel.COMMAND)));
        }
        for (Entity linkPrototype : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"IssueLinkPrototype"))) {
            Iterable links = IssueLinkPrototypeUtil.getLinkedIssues((Entity)issue, (Entity)linkPrototype, (boolean)true);
            if (!QueryOperations.isEmpty((Iterable)links)) {
                for (Entity linkedIssue : Sequence.fromIterable((Iterable)links)) {
                    CollectionSequence.fromCollection((Collection)commands).addElement((Object)(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkPrototype, (String)"IssueLinkPrototype")).getDefaultLocaleRoleName(true, linkPrototype) + " " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue)));
                }
            }
            if (QueryOperations.isEmpty((Iterable)(links = IssueLinkPrototypeUtil.getLinkedIssues((Entity)issue, (Entity)linkPrototype, (boolean)false)))) continue;
            for (Entity linkedIssue : Sequence.fromIterable((Iterable)links)) {
                CollectionSequence.fromCollection((Collection)commands).addElement((Object)(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)linkPrototype, (String)"IssueLinkPrototype")).getDefaultLocaleRoleName(false, linkPrototype) + " " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)linkedIssue, (String)"Issue")).getId(linkedIssue)));
            }
        }
        String visibleToPresentation = ((IField)ServiceLocator.getBean((String)"predefinedFieldVisibleTo")).getPresentation();
        if (Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"permittedGroup")).isNotEmpty()) {
            multivalueCommand = CollectionSequence.fromCollection(new ArrayList());
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"permittedGroup")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Collection)multivalueCommand, visibleToPresentation){
                final /* synthetic */ Collection val$multivalueCommand;
                final /* synthetic */ String val$visibleToPresentation;
                {
                    this.val$multivalueCommand = collection;
                    this.val$visibleToPresentation = string;
                }

                public void visit(Entity it) {
                    CollectionSequence.fromCollection((Collection)this.val$multivalueCommand).addElement((Object)(this.val$visibleToPresentation + " " + (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale())));
                }
            });
            CollectionSequence.fromCollection((Collection)commands).addElement((Object)IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand), (String)" "));
        }
        if (Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"permittedUser")).isNotEmpty()) {
            multivalueCommand = CollectionSequence.fromCollection(new ArrayList());
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"permittedUser")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Collection)multivalueCommand, visibleToPresentation){
                final /* synthetic */ Collection val$multivalueCommand;
                final /* synthetic */ String val$visibleToPresentation;
                {
                    this.val$multivalueCommand = collection;
                    this.val$visibleToPresentation = string;
                }

                public void visit(Entity it) {
                    CollectionSequence.fromCollection((Collection)this.val$multivalueCommand).addElement((Object)(this.val$visibleToPresentation + " " + (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"login", String.class, (Object)"<no user>")));
                }
            });
            CollectionSequence.fromCollection((Collection)commands).addElement((Object)IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)multivalueCommand), (String)" "));
        }
        ICollectionSequence tags = CollectionSequence.fromCollection(new ArrayList());
        for (Entity tag : Sequence.fromIterable((Iterable)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getTags(issue))) {
            CollectionSequence.fromCollection((Collection)tags).addElement((Object)("tag " + (String)PrimitiveAssociationSemantics.get((Entity)tag, (String)"name", String.class, (Object)IssueFolderImpl.getNullName())));
        }
        if (CollectionSequence.fromCollection((Collection)tags).isNotEmpty()) {
            CollectionSequence.fromCollection((Collection)commands).addElement((Object)IterableUtils.join((Iterable)CollectionSequence.fromCollection((Collection)tags), (String)" "));
        }
        return commands;
    }
}

