/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueCommentImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.commands.impl.BaseCommandExecutor;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Permission;

public class AddCommentCommandExecutor
extends BaseCommandExecutor {
    private String text;
    private Iterable<Entity> groups;
    private Iterable<Entity> users;
    private boolean usesMarkdown;

    public AddCommentCommandExecutor(String text, Iterable<Entity> groups, Iterable<Entity> users) {
        this.text = text;
        this.groups = groups;
        this.users = users;
    }

    public AddCommentCommandExecutor() {
        this("", null, null);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setUsesMarkdown(boolean usesMarkdown) {
        this.usesMarkdown = usesMarkdown;
    }

    public void setGroups(Iterable<Entity> userGroups) {
        this.groups = userGroups;
    }

    public void setUsers(Iterable<Entity> users) {
        this.users = users;
    }

    public void execute(Entity it) {
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).isDraft(it)) {
            throw new LogicException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AddCommentCommandExecutor.It_s_not_possible_to_add_comment_to_the_draft", new Object[0]));
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission(Permission.CREATE_COMMENT, AssociationSemantics.getToOne((Entity)it, (String)"project"), ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
            if (AddCommentCommandExecutor.isNotEmpty_c8r3og_a0a0b0e(this.text)) {
                final Entity c = IssueCommentImpl.constructor((String)this.text, (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Entity)it);
                PrimitiveAssociationSemantics.set((Entity)c, (String)"usesMarkdown", (Comparable)Boolean.valueOf(this.usesMarkdown), Boolean.class);
                boolean containsAllUsers = false;
                if (this.groups != null) {
                    if (!QueryOperations.isEmpty((Iterable)QueryOperations.query(this.groups, (String)"UserGroup", (NodeBase)new PropertyEqual("allUsersGroup", (Comparable)Boolean.TRUE)))) {
                        containsAllUsers = true;
                    } else {
                        UndirectedAssociationSemantics.clearManyToMany((Entity)c, (String)"permittedGroup", (String)"securedComments");
                        Sequence.fromIterable(this.groups).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                            public void visit(Entity __addallit__) {
                                UndirectedAssociationSemantics.createManyToMany((Entity)c, (String)"permittedGroup", (String)"securedComments", (Entity)__addallit__);
                            }
                        });
                    }
                }
                if (!containsAllUsers && this.users != null) {
                    UndirectedAssociationSemantics.clearManyToMany((Entity)c, (String)"permittedUser", (String)"visibleComments");
                    Sequence.fromIterable(this.users).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                        public void visit(Entity __addallit__) {
                            UndirectedAssociationSemantics.createManyToMany((Entity)c, (String)"permittedUser", (String)"visibleComments", (Entity)__addallit__);
                        }
                    });
                }
            }
        } else {
            throw new SecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AddCommentCommandExecutor.You_have_no_rights_to_create_comments_in_project_{0}", new Object[]{PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName())}));
        }
    }

    public String getDebugDescription() {
        return this.text;
    }

    public String getPresentation() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AddCommentCommandExecutor.Add_Comment", new Object[0]);
    }

    public static boolean isNotEmpty_c8r3og_a0a0b0e(String str) {
        return str != null && str.length() > 0;
    }
}

