/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFieldValue;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.highlight.IssueFieldsDecorator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.exodus.query.PropertyStartsWith;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.parser.runtime.lexer.Word;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.api.parser.Suggestion;
import jetbrains.youtrack.api.parser.SuggestionType;
import jetbrains.youtrack.commands.impl.AbstractTokensCell;
import jetbrains.youtrack.commands.impl.IIssueIdCell;
import jetbrains.youtrack.commands.impl.StringUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.textindex.TextIndexManagerCompat;
import org.jetbrains.annotations.Nullable;

public class AnyIssueIdCell
extends AbstractTokensCell
implements IIssueIdCell {
    private IssueFieldValue filterField;

    public AnyIssueIdCell(int startToken, int endToken, IFieldValue<Entity> filterField) {
        super(startToken, endToken, null, null);
        this.filterField = (IssueFieldValue)filterField;
    }

    @Override
    public Iterable<SuggestItem> getSuggestions(int pos) {
        return AnyIssueIdCell.getSuggestions(this.getTokens(), this.startToken, this.stopToken, this.getContext(), this.getStartOffset(pos), this.getEndOffset(pos), this.getMatch(pos), this.getText(this.startToken, pos));
    }

    public String getDebugDescription() {
        return "issueId:" + super.getCellText() + (EntityOperations.equals((Entity)this.getIssue(), null) ? "(bad)" : "");
    }

    @Override
    public Entity getIssue() {
        return this.filterField.getIssueEntity();
    }

    @Override
    public boolean isError() {
        if (EntityOperations.equals((Entity)this.getIssue(), null) || !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.getIssue(), (String)"Issue")).isAccessible(Operation.LINK, this.getIssue())) {
            return true;
        }
        Iterable selected = this.getContext().getSelectedIssues();
        return QueryOperations.getSize((Iterable)selected) == 1 && QueryOperations.contains((Iterable)selected, (Entity)this.getIssue());
    }

    @Override
    public String getText() {
        Entity issue = this.getIssue();
        if (!EntityOperations.equals((Entity)issue, null)) {
            if (!((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.LINK, issue)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AnyIssueIdCell.You_do_not_have_permission_to_add_link_for_issue_{0}", new Object[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)});
            }
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AnyIssueIdCell.Can_t_link_issue_with_itself", new Object[0]);
        }
        return super.getText();
    }

    public String getUnderlineStyle() {
        return "field";
    }

    public static Iterable<SuggestItem> getSuggestions(List<Word> tokens, int startToken, int endToken, IContext ctx, final int completionStart, final int completionEnd, int match, String prefix) {
        IListSequence allSelectedIssues = Sequence.fromIterable((Iterable)ctx.getSelectedIssues()).toListSequence();
        List selectedIssuesById = Collections.EMPTY_LIST;
        final String lowerCasePrefix = prefix.toLowerCase();
        if (allSelectedIssues.size() > 1) {
            selectedIssuesById = ListSequence.fromList((List)allSelectedIssues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).getId(it).toLowerCase().indexOf(lowerCasePrefix) != -1;
                }
            }).toListSequence();
        }
        Entity p = null;
        if (ctx.isSelectedIssuesFromSameProject()) {
            p = QueryOperations.getFirst((Iterable)ctx.getSelectedProjects());
        }
        final HashSet<Entity> selected = new HashSet<Entity>();
        selected.addAll((Collection<Entity>)allSelectedIssues);
        Iterable issuesById = AnyIssueIdCell.getIssuesByIdSearch(lowerCasePrefix, p);
        if (selectedIssuesById.size() > 0) {
            issuesById = QueryOperations.concat((Iterable)selectedIssuesById, issuesById);
        }
        ISequence resById = Sequence.fromIterable((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), issuesById)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !selected.contains(it);
            }
        }).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, SuggestItem>(){

            public SuggestItem select(Entity it) {
                return AnyIssueIdCell.getSuggestion(it, completionStart, completionEnd, lowerCasePrefix);
            }
        });
        return AnyIssueIdCell.getTextSearchSuggests(lowerCasePrefix, p, tokens, startToken, endToken, completionStart, completionEnd, (Iterable<SuggestItem>)resById, selected);
    }

    private static Iterable<Entity> getIssuesByIdSearch(String prefix, Entity p) {
        Object issuesById = prefix == null || prefix.length() == 0 ? (EntityOperations.equals((Entity)p, null) ? QueryOperations.queryGetAll((String)"Issue") : AssociationSemantics.getToMany((Entity)p, (String)"issues")) : AnyIssueIdCell.getIssuesByPrefixUnsecuredUnsorted(prefix, p);
        return QueryOperations.query((Iterable)issuesById, (String)"Issue", (NodeBase)new SortByProperty(null, "updated", false));
    }

    private static Iterable<Entity> getIssuesByPrefixUnsecuredUnsorted(String prefix, Entity preferableProject) {
        Iterable result = QueryOperations.empty((String)"Issue");
        if (prefix == null) {
            return result;
        }
        String[] prefixes = prefix.split("-");
        if (prefixes.length == 0) {
            return result;
        }
        if (prefixes.length == 1) {
            long numericPrefix = AnyIssueIdCell.parseNumberInProject(prefixes[0]);
            if (numericPrefix <= 0L) {
                TreeKeepingEntityIterable projects = prefix.endsWith("-") ? QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)prefixes[0]))) : QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyStartsWith("shortName", prefixes[0]));
                result = AnyIssueIdCell.issuesOfProjects((Iterable<Entity>)projects);
            } else {
                result = AnyIssueIdCell.getIssuesByNumberPrefix(numericPrefix);
                if (!EntityOperations.equals((Entity)preferableProject, null)) {
                    result = QueryOperations.intersect(result, AnyIssueIdCell.issuesOfProjects(QueryOperations.singleton((Entity)preferableProject)));
                }
            }
            return result;
        }
        long numberInProject = AnyIssueIdCell.parseNumberInProject(prefixes[1]);
        if (numberInProject <= 0L) {
            return result;
        }
        TreeKeepingEntityIterable projects = QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)prefixes[0])));
        if (QueryOperations.isEmpty((Iterable)projects)) {
            return result;
        }
        result = QueryOperations.intersect(AnyIssueIdCell.getIssuesByNumberPrefix(numberInProject), AnyIssueIdCell.issuesOfProjects((Iterable<Entity>)projects));
        return result;
    }

    private static Iterable<Entity> issuesOfProjects(Iterable<Entity> projects) {
        Iterable result = QueryOperations.empty((String)"Issue");
        for (Entity p : Sequence.fromIterable(projects)) {
            result = QueryOperations.union((Iterable)result, (Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("project", p)));
        }
        return result;
    }

    private static Iterable<Entity> getIssuesByNumberPrefix(long n) {
        Object result = QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(n)));
        long issueCount = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"Issue"));
        long addend = 1L;
        while (true) {
            addend *= 10L;
            if ((n *= 10L) >= issueCount) break;
            result = QueryOperations.union((Iterable)result, (Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new PropertyRange("numberInProject", (Comparable)Long.valueOf(n), PrimitiveAssociationSemantics.positiveInfinity(Long.class)), (NodeBase)new PropertyRange("numberInProject", PrimitiveAssociationSemantics.negativeInfinity(Long.class), PrimitiveAssociationSemantics.previousLess((Comparable)Long.valueOf(n + addend), Long.class)))));
        }
        return result;
    }

    private static long parseNumberInProject(String numStr) {
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected static Iterable<SuggestItem> getTextSearchSuggests(String prefix, Entity p, List<Word> tokens, int startToken, int endToken, final int completionStart, final int completionEnd, Iterable<SuggestItem> resById, final Set<Entity> excepting) {
        if (prefix != null && prefix.length() > 0 && prefix.length() >= 3) {
            final String[] searchWords = Word.toStrings(tokens, (int)startToken, (int)endToken);
            if (searchWords.length == 3 && searchWords[1].equals("-") && AnyIssueIdCell.isNatualIInt(searchWords[2]) && !EntityOperations.equals((Entity)QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)searchWords[0])))), null)) {
                prefix = '\"' + prefix + '\"';
            }
            Object issuesByTextSearch = EntityOperations.equals((Entity)p, null) ? QueryOperations.query(AnyIssueIdCell.search(null, prefix), (String)"Issue", (NodeBase)new SortByProperty(null, "updated", false)) : QueryOperations.concat((Iterable)QueryOperations.query(AnyIssueIdCell.search((Iterable<Entity>)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("project", p)), prefix), (String)"Issue", (NodeBase)new SortByProperty(null, "updated", false)), (Iterable)QueryOperations.query(AnyIssueIdCell.search((Iterable<Entity>)QueryOperations.query(null, (String)"Issue", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("project", p))), prefix), (String)"Issue", (NodeBase)new SortByProperty(null, "updated", false)));
            ISequence resByTextSuggest = Sequence.fromIterable((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)issuesByTextSearch)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !excepting.contains(it);
                }
            }).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, SuggestItem>(){

                public SuggestItem select(Entity it) {
                    return AnyIssueIdCell.getTextSearchSuggestion(it, searchWords, completionStart, completionEnd);
                }
            });
            return Sequence.fromIterable(resById).concat(Sequence.fromIterable((Iterable)resByTextSuggest));
        }
        return resById;
    }

    private static Iterable<Entity> search(@Nullable Iterable<Entity> issues, String query) {
        Iterable findIssuesBySummaryAndDescription = ((TextIndexManagerCompat)ServiceLocator.getBean((String)"textIndexManager")).findIssuesBySummaryAndDescription(issues, query);
        return findIssuesBySummaryAndDescription;
    }

    public static SuggestItem getSuggestion(Entity i, int completionStart, int completionEnd, String prefix) {
        int prefixLen = prefix.length();
        int matchStart = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).getId(i).toLowerCase().indexOf(prefix);
        int matchEnd = matchStart + prefixLen;
        Suggestion s = new Suggestion(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).getId(i), StringUtils.substring((String)PrimitiveAssociationSemantics.get((Entity)i, (String)"summary", String.class, null), 0, 70), completionStart, completionEnd, matchStart, matchEnd, SuggestionType.CATEGORY_VALUE);
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).isResolved(i)) {
            s.setOptionCssClass(Suggestion.RESOLVED_ISSUE_CSS_CLASS);
        }
        return s;
    }

    public static SuggestItem getTextSearchSuggestion(Entity i, String[] searchWords, int completionStart, int completionEnd) {
        Suggestion s = new Suggestion(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).getId(i), AnyIssueIdCell.getTextSearchDescription(i, searchWords), completionStart, completionEnd, SuggestionType.CATEGORY_VALUE);
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).isResolved(i)) {
            s.setOptionCssClass(Suggestion.RESOLVED_ISSUE_CSS_CLASS);
        }
        return s;
    }

    public static String getTextSearchDescription(Entity i, String[] searchWords) {
        return IssueFieldsDecorator.getHightlighed((String)((String)PrimitiveAssociationSemantics.get((Entity)i, (String)"summary", String.class, null)), (String[])searchWords, (int)70, (int)15) + " " + IssueFieldsDecorator.getHightlighed((String)PrimitiveAssociationSemantics.getBlobAsString((Entity)i, (String)"description"), (String[])searchWords, (int)70, (int)15);
    }

    private static boolean isNatualIInt(String s) {
        try {
            return Integer.parseInt(s) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

