/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.commands.PredefinedCommandType;
import jetbrains.youtrack.commands.impl.AbstractTokensCell;
import jetbrains.youtrack.commands.impl.CommandType;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import org.jetbrains.annotations.NotNull;

public class CommandTypeCell
extends AbstractTokensCell {
    public CommandTypeCell(int startToken, int endToken, @NotNull CommandType commandType) {
        super(startToken, endToken, commandType, null);
    }

    public String getDebugDescription() {
        return "commandType:" + this.getText();
    }

    public String getUnderlineStyle() {
        return "keyword";
    }

    @Override
    AbstractTokensCell.SuggestCollector addThisCellSuggestions(AbstractTokensCell.SuggestCollector collector, int pos) {
        return this.addAllSuggestions(collector, pos);
    }

    @Override
    public boolean isError() {
        if (!ServiceLocator.beanDefined((String)"applicationMetaData")) {
            return false;
        }
        if (this.commandType.isLink()) {
            return !this.getContext().isSelectedIssuesAccessible(Operation.LINK);
        }
        if (this.isPredefinedCommand(PredefinedCommandType.comment)) {
            return !this.getContext().hasPermissionForSelectedIssuesProjects(Permission.CREATE_COMMENT) || this.getContext().containsDrafts();
        }
        if (this.isDeleteIssueCommandTypeCell() && (this.getContext().containsDrafts() || this.isNotAloneDeleteCommand() || !this.getContext().isSelectedIssuesAccessible(Operation.DELETE))) {
            return true;
        }
        if (this.isPredefinedCommand(PredefinedCommandType.vote) || this.isPredefinedCommand(PredefinedCommandType.plusOne)) {
            return !this.getContext().isSelectedIssuesAccessible(Operation.READ) || !this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).canVote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), i);
                }
            });
        }
        if (this.isPredefinedCommand(PredefinedCommandType.unvote)) {
            return !this.getContext().isSelectedIssuesAccessible(Operation.READ) || !this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).canUnvote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), i);
                }
            });
        }
        return !EntityOperations.equals((Entity)this.getUnremovableField(), null);
    }

    @Override
    public String getText() {
        if (!ServiceLocator.beanDefined((String)"applicationMetaData")) {
            return super.getText();
        }
        if (this.commandType.isLink()) {
            if (!this.getContext().isSelectedIssuesAccessible(Operation.LINK)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_do_not_have_permissions_to_link_selected_issues", new Object[0]);
            }
        } else if (this.isPredefinedCommand(PredefinedCommandType.vote) || this.isPredefinedCommand(PredefinedCommandType.plusOne)) {
            if (!this.getContext().isSelectedIssuesAccessible(Operation.READ)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_do_not_have_permissions_to_vote_for_issue", new Object[0]);
            }
            if (!this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)i, (String)"reporter"), (Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
                }
            })) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_can_t_vote_for_your_own_issue_s", new Object[0]);
            }
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).isGuest(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.Guest_user_is_not_allowed_to_vote", new Object[0]);
            }
            if (!this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).hasVote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), i);
                }
            })) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_can_t_vote_for_the_issue_s_you_ve_already_voted_for", new Object[0]);
            }
        } else if (this.isPredefinedCommand(PredefinedCommandType.unvote)) {
            if (!this.getContext().isSelectedIssuesAccessible(Operation.READ)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_do_not_have_permission_to_unvote_issue", new Object[0]);
            }
            if (!this.getContext().allSelectedIssues((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, Entity>(){

                public Boolean invoke(Entity i) {
                    return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)i, (String)"Issue")).canUnvote(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), i);
                }
            })) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_can_t_unvote_selected_issue_s", new Object[0]);
            }
        } else if (this.isPredefinedCommand(PredefinedCommandType.comment)) {
            if (!this.getContext().hasPermissionForSelectedIssuesProjects(Permission.CREATE_COMMENT)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_do_not_have_permissions_to_add_comment", new Object[0]);
            }
            if (this.getContext().containsDrafts()) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.Can_t_add_comment_to_draft", new Object[0]);
            }
        } else if (this.isDeleteIssueCommandTypeCell()) {
            if (!this.getContext().isSelectedIssuesAccessible(Operation.DELETE)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.You_do_not_have_permissions_to_delete_selected_issues", new Object[0]);
            }
            if (this.isNotAloneDeleteCommand()) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.Delete_command_should_be_executed_alone", new Object[0]);
            }
            if (this.getContext().containsDrafts()) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.Delete_command_cannot_be_applied_to_draft_issue_Use_Clear_draft_instead", new Object[0]);
            }
        } else {
            Entity unremoveableField = this.getUnremovableField();
            if (!EntityOperations.equals((Entity)unremoveableField, null)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CommandTypeCell.Field_{0}_cannot_be_empty_in_project_{1}", new Object[]{((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)unremoveableField, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getNamePresentation(AssociationSemantics.getToOne((Entity)unremoveableField, (String)"prototype")), PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)unremoveableField, (String)"project"), (String)"name", String.class, (Object)IssueFolderImpl.getNullName())});
            }
        }
        return super.getText();
    }

    public boolean isDeleteIssueCommandTypeCell() {
        return this.isPredefinedCommand(PredefinedCommandType.delete);
    }

    private boolean isPredefinedCommand(PredefinedCommandType type2) {
        return this.commandType.isPredefined() && this.commandType.getPredefinedCommandType() == type2;
    }

    private boolean isNotAloneDeleteCommand() {
        ICommandList commandList2 = this.getCommand().getCommandList();
        for (ICommand command : Sequence.fromIterable((Iterable)commandList2.getCommands())) {
            if (command == this.getCommand() || command.getCommandExecutor() == null) continue;
            return true;
        }
        return false;
    }

    private Entity getUnremovableField() {
        Entity pcf;
        if (!this.commandType.isPredefined() || this.commandType.getPredefinedCommandType() != PredefinedCommandType.remove) {
            return null;
        }
        ICommandExecutor executor = this.command.getCommandExecutor();
        if (executor != null && executor.getField() != null && !EntityOperations.equals((Entity)(pcf = this.doGetUnremovableField(executor)), null)) {
            boolean after = false;
            for (ICommand otherCommand : Sequence.fromIterable((Iterable)this.command.getCommandList().getCommands())) {
                ICommandExecutor otherExecutor;
                if (otherCommand == this.command) {
                    after = true;
                    continue;
                }
                if (!after || (otherExecutor = otherCommand.getCommandExecutor()) == null || !EntityOperations.equals((Entity)otherExecutor.getField().getCustomFieldPrototype(), (Object)executor.getField().getCustomFieldPrototype()) || !Sequence.fromIterable((Iterable)otherCommand.getCells()).any((_FunctionTypes._return_P1_E0)new IWhereFilter<ICell>(){

                    public boolean accept(ICell it) {
                        return it instanceof AbstractTokensCell && ((AbstractTokensCell)it).commandType.getPredefinedCommandType() == PredefinedCommandType.add;
                    }
                })) continue;
                return null;
            }
            return pcf;
        }
        return null;
    }

    private Entity doGetUnremovableField(ICommandExecutor executor) {
        Entity prototype = executor.getField().getCustomFieldPrototype();
        if (!EntityOperations.equals((Entity)prototype, null)) {
            for (Entity project : Sequence.fromIterable((Iterable)this.getContext().getSelectedProjects())) {
                Entity pcf = ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)prototype, (String)"CustomFieldPrototype")).getProjectCustomField(project, prototype);
                if (((Boolean)PrimitiveAssociationSemantics.get((Entity)pcf, (String)"canBeEmpty", Boolean.class, null)).booleanValue()) continue;
                return pcf;
            }
        }
        return null;
    }
}

