/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.persistent.IssueFieldValue;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.parser.runtime.lexer.Word;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.commands.impl.AbstractTokensCell;
import jetbrains.youtrack.commands.impl.AnyIssueIdCell;
import jetbrains.youtrack.commands.impl.IIssueIdCell;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.textindex.TextIndexOperationsCompat;

public class LinkedIssueIdCell
extends AbstractTokensCell
implements IIssueIdCell {
    private IssueFieldValue filterField;
    private Entity linkPrototype;
    private boolean outward;

    public LinkedIssueIdCell(int startToken, int endToken, IFieldValue<Entity> filterField, Entity linkPrototype, boolean outward) {
        super(startToken, endToken, null, null);
        this.filterField = (IssueFieldValue)filterField;
        this.linkPrototype = linkPrototype;
        this.outward = outward;
    }

    @Override
    public Iterable<SuggestItem> getSuggestions(int pos) {
        return LinkedIssueIdCell.getSuggestions(this.getTokens(), this.startToken, this.stopToken, this.getContext(), this.getStartOffset(pos), this.getEndOffset(pos), this.getMatch(pos), this.getText(this.startToken, pos), this.linkPrototype, this.outward);
    }

    public String getDebugDescription() {
        return "issueId:" + super.getCellText() + (this.isError() ? "(bad)" : "");
    }

    @Override
    public Entity getIssue() {
        return this.filterField.getIssueEntity();
    }

    @Override
    public boolean isError() {
        return !QueryOperations.contains((Iterable)this.getContext().getLinkedIssues(this.linkPrototype, this.outward), (Entity)this.getIssue()) || EntityOperations.equals((Entity)this.getIssue(), null) || !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.getIssue(), (String)"Issue")).isAccessible(Operation.LINK, this.getIssue());
    }

    @Override
    public String getText() {
        Entity issue = this.getIssue();
        if (!EntityOperations.equals((Entity)issue, null)) {
            if (!((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.LINK, issue)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("LinkedIssueIdCell.You_do_not_have_permissions_to_remove_link_for_issue_{0}", new Object[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)});
            }
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("LinkedIssueIdCell.No_link_to_remove_found_for_issue_{0}", new Object[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)});
        }
        return super.getText();
    }

    public String getUnderlineStyle() {
        return "field";
    }

    public static Iterable<SuggestItem> getSuggestions(final List<Word> tokens, final int startToken, final int endToken, IContext ctx, final int completionStart, final int completionEnd, int match, String prefix, Entity linkPrototype, boolean outward) {
        Iterable linkedIssues = ctx.getLinkedIssues(linkPrototype, outward);
        final String lowerCasePrefix = prefix.toLowerCase();
        ISequence searchById = Sequence.fromIterable((Iterable)linkedIssues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).getId(it).toLowerCase().indexOf(lowerCasePrefix) != -1;
            }
        });
        ISequence res = Sequence.fromIterable((Iterable)searchById).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, SuggestItem>(){

            public SuggestItem select(Entity it) {
                return AnyIssueIdCell.getSuggestion(it, completionStart, completionEnd, lowerCasePrefix);
            }
        });
        Iterable textSearchResult = TextIndexOperationsCompat.getTextIndexManager().findIssues(linkedIssues, lowerCasePrefix);
        res = Sequence.fromIterable((Iterable)res).union(Sequence.fromIterable((Iterable)QueryOperations.exclude((Iterable)textSearchResult, (Iterable)searchById)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, SuggestItem>(){

            public SuggestItem select(Entity it) {
                return AnyIssueIdCell.getTextSearchSuggestion(it, Word.toStrings((List)tokens, (int)startToken, (int)endToken), completionStart, completionEnd);
            }
        }));
        return res;
    }
}

