/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import jetbrains.mps.parser.runtime.base.SuggestItem;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.parser.LocalizedSuggestItemSeparator;
import jetbrains.youtrack.commands.impl.CachedRecentCommand;
import jetbrains.youtrack.commands.impl.RecentCommandImpl;
import jetbrains.youtrack.commands.impl.StringUtils;
import webr.framework.controller.BaseApplication;

public class RecentCommandsCache
implements Serializable {
    public static int MAX_SAVED_COMMANDS = 10;
    private static final SuggestItem SEPARATOR = new LocalizedSuggestItemSeparator("recent_commands.description");
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private List<CachedRecentCommand> commands = ListSequence.fromList((List)new LinkedList());

    private RecentCommandsCache(Entity user) {
        this.init(user);
    }

    private void init(Entity user) {
        for (Entity rc : Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)user, (String)"profile"), (String)"recentCommands"), (String)"RecentCommand", (NodeBase)new SortByProperty(null, "recentExecution", false)))) {
            ListSequence.fromList(this.commands).addElement((Object)new CachedRecentCommand(user, (String)PrimitiveAssociationSemantics.get((Entity)rc, (String)"command", String.class, null), PrimitiveAssociationSemantics.getBlobAsString((Entity)rc, (String)"comment"), AssociationSemantics.getToMany((Entity)rc, (String)"permittedGroup"), AssociationSemantics.getToMany((Entity)rc, (String)"permittedUser"), (Long)PrimitiveAssociationSemantics.get((Entity)rc, (String)"recentExecution", null)));
        }
    }

    public CachedRecentCommand getLastCommand() {
        return ListSequence.fromList(this.commands).isEmpty() ? null : (CachedRecentCommand)((Object)ListSequence.fromList(this.commands).first());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<SuggestItem> getSuggests(final String command, final int cursorPos) {
        final String commandToCursor = StringUtils.substring(command, 0, cursorPos).toLowerCase();
        ReentrantReadWriteLock.ReadLock lock = this.lock.readLock();
        try {
            lock.lock();
            IListSequence res = ListSequence.fromList((List)new LinkedList());
            ListSequence.fromList((List)res).addSequence(ListSequence.fromList(this.commands).where((_FunctionTypes._return_P1_E0)new IWhereFilter<CachedRecentCommand>(){

                public boolean accept(CachedRecentCommand it) {
                    return it.getOption().toLowerCase().startsWith(commandToCursor);
                }
            }).select((_FunctionTypes._return_P1_E0)new ISelector<CachedRecentCommand, CachedRecentCommand>(){

                public CachedRecentCommand select(CachedRecentCommand it) {
                    CachedRecentCommand cachedCommand = new CachedRecentCommand(it);
                    cachedCommand.setCompletionEnd(command.length());
                    cachedCommand.setMatchingEnd(cursorPos);
                    cachedCommand.setSuffix(" ");
                    cachedCommand.setGroup(SEPARATOR.getDescription());
                    return cachedCommand;
                }
            }));
            if (ListSequence.fromList((List)res).isNotEmpty()) {
                ListSequence.fromList((List)res).insertElement(0, (Object)SEPARATOR);
            }
            IListSequence iListSequence = res;
            return iListSequence;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandExecuted(Entity user, String command, String comment2, Iterable<Entity> groups, Iterable<Entity> users) {
        String string = command = command == null ? null : command.trim();
        if (command == null || command.length() == 0) {
            return;
        }
        RecentCommandImpl.commandExecuted(user, command, comment2, groups, users);
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.commands.clear();
            this.init(user);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecentCommandsCache get(Entity user) {
        if (!BaseApplication.isInsideRequestProcessing()) {
            return null;
        }
        if ((RecentCommandsCache)BaseApplication.getSessionField((String)"recentCommandsCache", (boolean)true) == null) {
            HttpSession httpSession = BaseApplication.getRequest().getSession();
            synchronized (httpSession) {
                BaseApplication.setSessionField((String)"recentCommandsCache", (Object)new RecentCommandsCache(user), (boolean)true);
            }
        }
        return (RecentCommandsCache)BaseApplication.getSessionField((String)"recentCommandsCache", (boolean)true);
    }

    @Deprecated
    public static RecentCommandsCache getForTesting(Entity user) {
        try {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)user);
            RecentCommandsCache recentCommandsCache = new RecentCommandsCache(user);
            return recentCommandsCache;
        }
        finally {
            ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
        }
    }
}

