charisma.smartui.CommandDialogConfig = function () {
};
charisma.smartui.CommandDialogConfig.prototype.updateComment = function (comment) {
};
charisma.smartui.CommandDialogConfig.prototype.show = function (issue) {
};
charisma.smartui.CommandDialogConfig.prototype.submit = function (focusedIssue, command) {
};
charisma.smartui.CommandDialogConfig.prototype.repeatLastCommand = function (focusedIssue) {
};
charisma.smartui.CommandDialogConfig.prototype.invokedByKeyboardCallback = function () {
};
charisma.smartui.CommandDialog = function (config) {
  charisma.smartui.CommandDialog.superclass.constructor.call(this);
  this.catchLetters = true;
  this.modalDiv = null;
  this.visible = false;
  this.pageControler = commonController;
  this.pageControler.setCommandDialog(this);
  this.config = config;
  this.initSuggest();
  this.initCommandField();
  this.initCommentTextArea();
  this.initDocumentHandlers();
  this.initDialog();
};
{
  var F = new Function();
  F.prototype = Webr.component.Component.prototype;
  charisma.smartui.CommandDialog.prototype = new F();
  charisma.smartui.CommandDialog.prototype.constructor = charisma.smartui.CommandDialog;
  charisma.smartui.CommandDialog.superclass = Webr.component.Component.prototype;
}

charisma.smartui.CommandDialog.prototype.initSuggest = function () {
  this.suggestComponent = this.config.commandText.getSuggest({baseSuggestOffset: -5, propogateImplicitComplete: true});
  this.suggestComponent.getInputPosition = function () {
    var p = $(this.input).offset();
    p.top -= $(document).scrollTop();
    return p;
  };
  this.suggestComponent.suggestDivPosition = "fixed";
  this.suggestComponent.addListener(this);
};
charisma.smartui.CommandDialog.prototype.initDialog = function () {
  var it = this;
  this.config.dialog.panel.keyrepeatable(function (e) {
    //ctrl is required, to let simple enter work in comment textarea
    if (e.isCtrl(Webr.util.Key.ENTER) || e.isMeta(Webr.util.Key.ENTER)) {
      it.config.applyButton.click();
      return false;
    } else if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["SilentApplyCommand"])) {
      it.config.silentApplyButton.click();
      return false;
    } else if (e.isKey(Webr.util.Key.ESC)) {
      it.hide();
      return false;
    }

    return true;
  });
};
charisma.smartui.CommandDialog.prototype.initCommandField = function () {
  var it = this;
  $(this.config.commandText).bind("valuechange", function (event, data) {
    it.underlineAndSuggest(data.caretPos);
  }).bind("caretmove", function (event, data) {
    it.suggest(data.caretPos);
  });
  this.config.commandText.attachWatcher(false);
  this.config.commandText.setWatcherDelay(150);
};
charisma.smartui.CommandDialog.prototype.initCommentTextArea = function () {
  var it = this;
  $(this.config.commentTextArea).bind("valuechange", function () {
    it.serverUpdateComment();
  });
  $(this.config.markdownToggler).bind("change", function () {
    it.serverUpdateComment();
  });
    

  this.config.commentTextArea.attachWatcher(false);
};
charisma.smartui.CommandDialog.prototype.initDocumentHandlers = function () {
  var it = this;
  //handle document
  $(document).keypress(function (e) {
    return it.noFocusElementKeyPressed(e);
  });
  $(document).keydown(function (e) {
    return it.documentKeyDownHandler(e);
  });
};
charisma.smartui.CommandDialog.prototype.setCatchLetters = function (enabled) {
  this.catchLetters = enabled;
};
charisma.smartui.CommandDialog.prototype.documentKeyDownHandler = function (e) {
  if (Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible()) {
    return true;
  }

  //handle Alt-Ctrl-J
  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["CommandDialog"])) {
    this.show("");
    if (e.targetIsInput()) {
      this.returnFocus = $(e.target);
    }

    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["RepeatLastCommand"])) {
    this.repeatLastCommand();
    return false;
  }

  return true;
};
charisma.smartui.CommandDialog.prototype.noFocusElementKeyPressed = function (e) {
  if (e.targetIsInput() || Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible() || !this.catchLetters) {
    return true;
  }

  //handle letters
  if (!(e.altKey || e.ctrlKey || e.metaKey)) {
    var s = this.getCharPressedForKeyPressedEvent(e);
    if (s != null) {
      this.show(s);
      try {
        this.config.invokedByKeyboardCallback();
      } catch (error) {
      }

      return false;
    }

  }

  return true;
};
charisma.smartui.CommandDialog.prototype.getCharPressedForKeyPressedEvent = function (e) {
  var originalEvent = e["originalEvent"];
  var charCode = (originalEvent.which != undefined ?originalEvent.which :originalEvent.keyCode);
  if (charCode > 0 && charCode < 63000) {
    if (charCode >= "0".charCodeAt(0) && charCode <= "9".charCodeAt(0) || charCode >= "A".charCodeAt(0)) {
      return String.fromCharCode(charCode);
    }

  }

  return null;
};
charisma.smartui.CommandDialog.prototype.show = function (command, focusToComment) {
  this.fromAssign = false;
  this._doShow(command, focusToComment);
};
charisma.smartui.CommandDialog.prototype.showFromAssign = function (command, focusToComment) {
  this.fromAssign = true;
  this._doShow(command, focusToComment);
};
charisma.smartui.CommandDialog.prototype._doShow = function (command, focusToComment) {
  this.returnFocus = null;
  if (!this.pageControler.getFocusedIssueId()) {
    return ;
  }

  //bind rest
  charisma.RestMethods.bind(this.config.commandText, new charisma.CommandRest(null, this.getPackagedIssueIds(), this.getQuery(), this.config.commandsDescription));
  //send to server
  if (this.config.show(this.pageControler.getFocusedIssueId()) === false) {
    //prevent show a dialog if attachment is shown
    return ;
  }

  //other stuff
  this.pageControler.searchField && this.pageControler.searchField.getSuggest().hide();
  this.config.dialog.setVisible(true);
  this.config.commentTextArea.value = "";
  this.config.commandText.value = command;
  this.config.commandText.fireValueChange(command.length, command);
  if (focusToComment == true) {
    this.config.commentTextArea.focus();
  } else {
    this.config.commandText.setCaretPosition(command.length);
    $(this.config.commandText).focus();
  }

};
charisma.smartui.CommandDialog.prototype.execute = function (command) {
  this.fromAssign = false;
  if (!this.pageControler.getFocusedIssueId()) {
    return ;
  }

  this.config.submit(this.pageControler.getFocusedIssueId(), command);
};
charisma.smartui.CommandDialog.prototype.executeFromAssign = function (command) {
  this.fromAssign = true;
  try {
    if (!this.pageControler.getFocusedIssueId()) {
      return ;
    }

    this.config.submit(this.pageControler.getFocusedIssueId(), command);
  } finally {
    this.fromAssign = false;
  }

};
charisma.smartui.CommandDialog.prototype.repeatLastCommand = function () {
  this.fromAssign = false;
  if (!this.pageControler.getFocusedIssueId()) {
    return ;
  }

  this.config.repeatLastCommand(this.pageControler.getFocusedIssueId());
};
charisma.smartui.CommandDialog.prototype.serverProcessedShow = function () {
  this.visible = true;
};
charisma.smartui.CommandDialog.prototype.setSampleText = function (text) {
  this.config.commandText.focus();
  this.config.commandText.value = text;
  this.config.commandText.setCaretPosition(text.length);
};
charisma.smartui.CommandDialog.prototype.hide = function () {
  this.suggestComponent.blur();
  this.config.commandText.blur();
  this.config.commentTextArea.blur();
  this.fire(function (l) {
    l.commandsHide();
  });
  this.config.dialog.setVisible(false);
  this.config.commandText.value = "";
  this.config.commandText.underline("", null);
  this.visible = false;
  if (this.returnFocus) {
    this.returnFocus.focus();
  }

};
charisma.smartui.CommandDialog.prototype.serverUpdateComment = function () {
  var t = this;
  this.callOnVisible(function () {
    t.config.updateComment(t.config.commentTextArea.value);
  });
};
charisma.smartui.CommandDialog.prototype.allFoundIssuesAreSelected = function () {
  return this.pageControler.allFoundIssuesAreSelected();
};
charisma.smartui.CommandDialog.prototype.getQuery = function () {
  if (this.allFoundIssuesAreSelected()) {
    return this.pageControler.getQuery();
  } else {
    return null;
  }

};
charisma.smartui.CommandDialog.prototype.getPackagedIssueIds = function () {
  if (!this.allFoundIssuesAreSelected()) {
    //issues list of FSI
    var issueIds = this.pageControler.getSelectedIssuesIds();
    return charisma.smartui.IssueId.encodeIssueIds(issueIds);
  } else {
    return null;
  }

};
charisma.smartui.CommandDialog.prototype.keyDown = function (source, event) {
  //from suggest
  if (source == this.suggestComponent) {
    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["ForceComplete"])) {
      this.suggest();
      return false;
    } else if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["ApplyCommand"])) {
      this.config.applyButton.click();
      return false;
    } else if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SilentApplyCommand"])) {
      this.config.silentApplyButton.click();
      return false;
    }

  }

    

  return true;
};
charisma.smartui.CommandDialog.prototype.isVisible = function () {
  return this.visible;
};
charisma.smartui.CommandDialog.prototype.suggest = function (cursorPos) {
  var t = this;
  this.callOnVisible(function () {
    charisma.RestMethods.$(t.config.commandText).suggest(cursorPos);
  });
};
charisma.smartui.CommandDialog.prototype.underlineAndSuggest = function (cursorPos) {
  var t = this;
  this.callOnVisible(function () {
    charisma.RestMethods.$(t.config.commandText).underlineAndSuggest(cursorPos);
  });
};
charisma.smartui.CommandDialog.prototype.callOnVisible = function (f) {
  var t = this;
  this.repeat(function () {
    if (t.isVisible()) {
      f();
    }

    return t.isVisible();
  }, 150, 10);
};
charisma.smartui.CommandDialog.prototype.repeat = function (f, interval, times) {
  var handle = window.setInterval(function () {
    if (f() || ((times -= 1) < 0)) {
      window.clearTimeout(handle);
    }

  }, interval);
};
charisma.smartui.CommandsListener = function () {
  charisma.smartui.CommandsListener.superclass.constructor.call(this);
};
{
  var F = new Function();
  F.prototype = Webr.component.ComponentListener.prototype;
  charisma.smartui.CommandsListener.prototype = new F();
  charisma.smartui.CommandsListener.prototype.constructor = charisma.smartui.CommandsListener;
  charisma.smartui.CommandsListener.superclass = Webr.component.ComponentListener.prototype;
}

charisma.smartui.CommandsListener.prototype.commandsHide = function (source) {
};


var commandDialog;
