/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.dates;

import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeArithmetics;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;

public class DateMath {
    public static Long getDateStartInTimezone(Long time, DateTimeZone zone) {
        return DateTimeOperations.convert((DateTime)new DateTime((Object)time, zone).withTimeAtStartOfDay());
    }

    public static Long getDateFinishInTimezone(Long time, DateTimeZone zone) {
        return DateTimeOperations.convert((DateTime)new DateTime((Object)time, zone).withTimeAtStartOfDay().plusDays(1)) - 1L;
    }

    public static Long shiftTimeToZone(Long time, DateTimeZone from, DateTimeZone to) {
        return DateTimeOperations.convert((DateTime)new DateTime((Object)time, from).withZoneRetainFields(to));
    }

    public static Long getSameDateStartInUTC(Long time, DateTimeZone zone) {
        Long dayStartInUserTimeZone = DateMath.getDateStartInTimezone(time, zone);
        return DateMath.shiftTimeToZone(dayStartInUserTimeZone, zone, DateTimeZone.UTC);
    }

    public static boolean isDateStartInUTC(Long time) {
        return DateTimeOperations.compare((Duration)DateTimeArithmetics.minus((Long)DateTimeOperations.convert((DateTime)new DateTime((Object)time, DateTimeZone.UTC).withTimeAtStartOfDay()), (Long)time), (CompareType)CompareType.EQ, (Long)0L);
    }

    public static boolean isDateMiddleInUTC(Long time) {
        return DateTimeOperations.compare((Duration)DateTimeArithmetics.minus((Long)DateTimeOperations.convert((DateTime)new DateTime((Object)time, DateTimeZone.UTC).withTime(12, 0, 0, 0)), (Long)time), (CompareType)CompareType.EQ, (Long)0L);
    }

    public static boolean isDateFinishInUTC(Long time) {
        return DateTimeOperations.compare((Duration)DateTimeArithmetics.minus((Long)DateTimeOperations.convert((DateTime)new DateTime((Object)time, DateTimeZone.UTC).plusDays(1).withTimeAtStartOfDay()), (Long)time), (CompareType)CompareType.EQ, (Long)1L);
    }
}

