/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.ssl;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdKeyStorage;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.core.ssl.XdTrustStorage;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"keyStorage", "Ljetbrains/youtrack/core/ssl/XdKeyStorage;", "getKeyStorage", "()Ljetbrains/youtrack/core/ssl/XdKeyStorage;", "logger", "Lmu/KLogger;", "trustStorage", "Ljetbrains/youtrack/core/ssl/XdTrustStorage;", "getTrustStorage", "()Ljetbrains/youtrack/core/ssl/XdTrustStorage;", "createSSLContext", "Ljavax/net/ssl/SSLContext;", "key", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "youtrack-core"})
public final class SSLContextFactoryKt {
    private static final KLogger logger = new KLogging().logger("jetbrains.youtrack.core.ssl");

    @NotNull
    public static final XdKeyStorage getKeyStorage() {
        String name$iv = "keyStorage";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
        }
        return (XdKeyStorage)XdExtensionsKt.toXd((Entity)((Entity)((TransientEntity)object)));
    }

    private static final XdTrustStorage getTrustStorage() {
        String name$iv = "trustStorage";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
        }
        return (XdTrustStorage)XdExtensionsKt.toXd((Entity)((Entity)((TransientEntity)object)));
    }

    @NotNull
    public static final SSLContext createSSLContext(@Nullable XdStorageEntry key) {
        createSSLContext.1 getKeyManagers$ = createSSLContext.1.INSTANCE;
        createSSLContext.2 getTrustManagers$ = createSSLContext.2.INSTANCE;
        try {
            SSLContext sSLContext;
            SSLContext $receiver = sSLContext = SSLContext.getInstance("TLS");
            $receiver.init(createSSLContext.1.INSTANCE.invoke(key), createSSLContext.2.INSTANCE.invoke(), new SecureRandom());
            SSLContext sSLContext2 = sSLContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext2, (String)"SSLContext.getInstance(\"\u2026SecureRandom())\n        }");
            return sSLContext2;
        }
        catch (GeneralSecurityException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public static /* synthetic */ SSLContext createSSLContext$default(XdStorageEntry xdStorageEntry, int n, Object object) {
        if ((n & 1) != 0) {
            xdStorageEntry = null;
        }
        return SSLContextFactoryKt.createSSLContext(xdStorageEntry);
    }

    @NotNull
    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    @NotNull
    public static final /* synthetic */ XdTrustStorage access$getTrustStorage$p() {
        return SSLContextFactoryKt.getTrustStorage();
    }
}

