/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J3\u0010\n\u001a\u0004\u0018\u00010\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J+\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\f2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0016\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/core/ssl/YouTrackKeyManager;", "Ljavax/net/ssl/X509KeyManager;", "delegate", "storageEntry", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljavax/net/ssl/X509KeyManager;Ljetbrains/youtrack/core/ssl/XdStorageEntry;)V", "alias", "", "checkAlias", "", "chooseClientAlias", "array", "", "array1", "Ljava/security/Principal;", "socket", "Ljava/net/Socket;", "([Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "chooseServerAlias", "string", "(Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "getCertificateChain", "Ljava/security/cert/X509Certificate;", "(Ljava/lang/String;)[Ljava/security/cert/X509Certificate;", "getClientAliases", "(Ljava/lang/String;[Ljava/security/Principal;)[Ljava/lang/String;", "getPrivateKey", "Ljava/security/PrivateKey;", "getServerAliases", "youtrack-core"})
public final class YouTrackKeyManager
implements X509KeyManager {
    private final String alias;
    private final X509KeyManager delegate;

    @Override
    @NotNull
    public PrivateKey getPrivateKey(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        this.checkAlias(alias);
        PrivateKey privateKey = this.delegate.getPrivateKey(alias);
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"this.delegate.getPrivateKey(alias)");
        return privateKey;
    }

    @Override
    @NotNull
    public X509Certificate[] getCertificateChain(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        this.checkAlias(alias);
        X509Certificate[] x509CertificateArray = this.delegate.getCertificateChain(alias);
        Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateArray, (String)"this.delegate.getCertificateChain(alias)");
        return x509CertificateArray;
    }

    @Override
    @Nullable
    public String chooseServerAlias(@NotNull String string, @NotNull Principal[] array, @NotNull Socket socket) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        return this.alias;
    }

    @Override
    @NotNull
    public String[] getServerAliases(@NotNull String string, @NotNull Principal[] array) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        return new String[]{this.alias};
    }

    @Override
    @Nullable
    public String chooseClientAlias(@NotNull String[] array, @NotNull Principal[] array1, @NotNull Socket socket) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)array1, (String)"array1");
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        return this.alias;
    }

    @Override
    @NotNull
    public String[] getClientAliases(@NotNull String string, @NotNull Principal[] array) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        return new String[]{this.alias};
    }

    private final void checkAlias(String alias) {
        if (Intrinsics.areEqual((Object)alias, (Object)this.alias) ^ true) {
            throw (Throwable)new IllegalArgumentException("No entry under alias '" + alias + "' or it's illegal to use it in this context");
        }
    }

    public YouTrackKeyManager(@NotNull X509KeyManager delegate, @Nullable XdStorageEntry storageEntry) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        XdStorageEntry xdStorageEntry = storageEntry;
        this.alias = xdStorageEntry != null ? xdStorageEntry.getKeystoreAlias() : null;
    }
}

