/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.awsses;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.List;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.notifications.awsses.BouncePollingScheduling;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "()V", "cron", "", "getCron", "()Ljava/lang/String;", "queue", "kotlin.jvm.PlatformType", "sqs", "Lcom/amazonaws/services/sqs/AmazonSQS;", "getSqs", "()Lcom/amazonaws/services/sqs/AmazonSQS;", "sqs$delegate", "Lkotlin/Lazy;", "execute", "", "handleBounce", "message", "Lcom/amazonaws/services/sqs/model/Message;", "shouldSchedule", "", "Companion", "SesBounce", "SesBouncedRecipient", "SnsMessage", "youtrack-custom-notifications"})
public final class BouncePollingScheduling
extends LocalCronScheduling {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String queue = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.awsses.queue");
    private final Lazy sqs$delegate = LazyKt.lazy((Function0)sqs.2.INSTANCE);
    @NotNull
    private final String cron = "0 */5 * * * ?";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BouncePollingScheduling.class), "sqs", "getSqs()Lcom/amazonaws/services/sqs/AmazonSQS;"))};
        Companion = new Companion(null);
    }

    private final AmazonSQS getSqs() {
        Lazy lazy = this.sqs$delegate;
        BouncePollingScheduling bouncePollingScheduling = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (AmazonSQS)lazy.getValue();
    }

    public boolean shouldSchedule() {
        return this.queue != null;
    }

    @NotNull
    public String getCron() {
        return this.cron;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() {
        try {
            int n = 0;
            int n2 = 10;
            while (n <= n2) {
                void x;
                ReceiveMessageResult receiveMessageResult = this.getSqs().receiveMessage(this.queue);
                Intrinsics.checkExpressionValueIsNotNull((Object)receiveMessageResult, (String)"sqs.receiveMessage(queue)");
                List list = receiveMessageResult.getMessages();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"sqs.receiveMessage(queue).messages");
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    Message it;
                    Message message = it = (Message)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"it");
                    this.handleBounce(message);
                    this.getSqs().deleteMessage(this.queue, it.getReceiptHandle());
                }
                ++x;
            }
        }
        catch (Exception e) {
            Companion.getLogger().warn("Got error while fetching bounce notifications from AWS SES", (Throwable)e);
        }
    }

    private final void handleBounce(Message message) {
        try {
            JsonElement jsonElement = new JsonParser().parse(message.getBody());
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"JsonParser().parse(message.body)");
            JsonElement jsonElement2 = jsonElement.getAsJsonObject().get("Message");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"JsonParser().parse(messa\u2026JsonObject.get(\"Message\")");
            String snsMessage = jsonElement2.getAsString();
            SesBounce bounce = ((SnsMessage)new Gson().fromJson(snsMessage, SnsMessage.class)).getBounce();
            Iterable $receiver$iv = bounce.getBouncedRecipients();
            for (Object element$iv : $receiver$iv) {
                SesBouncedRecipient recipient = (SesBouncedRecipient)element$iv;
                List users2 = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdUser.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdUser, Unit>(recipient){
                    final /* synthetic */ SesBouncedRecipient $recipient;

                    public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdUser it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        $receiver.eq((Comparable)((Object)it.getEmail()), (Comparable)((Object)this.$recipient.getEmailAddress()));
                    }
                    {
                        this.$recipient = sesBouncedRecipient;
                        super(2);
                    }
                })));
                Iterable $receiver$iv2 = users2;
                for (Object element$iv2 : $receiver$iv2) {
                    XdUser user = (XdUser)element$iv2;
                    user.getProfile().setEmailBlocked(true);
                    user.getProfile().setEmailBlockReason(recipient.getStatus() + ' ' + recipient.getDiagnosticCode());
                    Companion.getLogger().info("Got a bounce for user " + user.getVisibleNameWithLogin() + ", blocking email notifications. " + bounce.getFeedbackId() + ' ' + recipient.getStatus() + ' ' + recipient.getDiagnosticCode());
                }
            }
            Companion.getLogger().debug((Function0)new Function0<String>(message){
                final /* synthetic */ Message $message;

                @NotNull
                public final String invoke() {
                    return "Bounce received: " + this.$message.getBody();
                }
                {
                    this.$message = message;
                    super(0);
                }
            });
        }
        catch (Exception e) {
            Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(message){
                final /* synthetic */ Message $message;

                @NotNull
                public final String invoke() {
                    return "Failed to process bounce notification from AWS SES. Raw text is: \n" + this.$message.getBody();
                }
                {
                    this.$message = message;
                    super(0);
                }
            });
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SnsMessage;", "", "bounce", "Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBounce;", "(Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBounce;)V", "getBounce", "()Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBounce;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "youtrack-custom-notifications"})
    public static final class SnsMessage {
        @NotNull
        private final SesBounce bounce;

        @NotNull
        public final SesBounce getBounce() {
            return this.bounce;
        }

        public SnsMessage(@NotNull SesBounce bounce) {
            Intrinsics.checkParameterIsNotNull((Object)bounce, (String)"bounce");
            this.bounce = bounce;
        }

        @NotNull
        public final SesBounce component1() {
            return this.bounce;
        }

        @NotNull
        public final SnsMessage copy(@NotNull SesBounce bounce) {
            Intrinsics.checkParameterIsNotNull((Object)bounce, (String)"bounce");
            return new SnsMessage(bounce);
        }

        @NotNull
        public static /* synthetic */ SnsMessage copy$default(SnsMessage snsMessage, SesBounce sesBounce, int n, Object object) {
            if ((n & 1) != 0) {
                sesBounce = snsMessage.bounce;
            }
            return snsMessage.copy(sesBounce);
        }

        @NotNull
        public String toString() {
            return "SnsMessage(bounce=" + this.bounce + ")";
        }

        public int hashCode() {
            SesBounce sesBounce = this.bounce;
            return sesBounce != null ? ((Object)sesBounce).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SnsMessage)) break block3;
                    SnsMessage snsMessage = (SnsMessage)object;
                    if (!Intrinsics.areEqual((Object)this.bounce, (Object)snsMessage.bounce)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBounce;", "", "bounceType", "", "feedbackId", "bouncedRecipients", "", "Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBouncedRecipient;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBounceType", "()Ljava/lang/String;", "getBouncedRecipients", "()Ljava/util/List;", "getFeedbackId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "youtrack-custom-notifications"})
    public static final class SesBounce {
        @NotNull
        private final String bounceType;
        @NotNull
        private final String feedbackId;
        @NotNull
        private final List<SesBouncedRecipient> bouncedRecipients;

        @NotNull
        public final String getBounceType() {
            return this.bounceType;
        }

        @NotNull
        public final String getFeedbackId() {
            return this.feedbackId;
        }

        @NotNull
        public final List<SesBouncedRecipient> getBouncedRecipients() {
            return this.bouncedRecipients;
        }

        public SesBounce(@NotNull String bounceType, @NotNull String feedbackId, @NotNull List<SesBouncedRecipient> bouncedRecipients) {
            Intrinsics.checkParameterIsNotNull((Object)bounceType, (String)"bounceType");
            Intrinsics.checkParameterIsNotNull((Object)feedbackId, (String)"feedbackId");
            Intrinsics.checkParameterIsNotNull(bouncedRecipients, (String)"bouncedRecipients");
            this.bounceType = bounceType;
            this.feedbackId = feedbackId;
            this.bouncedRecipients = bouncedRecipients;
        }

        @NotNull
        public final String component1() {
            return this.bounceType;
        }

        @NotNull
        public final String component2() {
            return this.feedbackId;
        }

        @NotNull
        public final List<SesBouncedRecipient> component3() {
            return this.bouncedRecipients;
        }

        @NotNull
        public final SesBounce copy(@NotNull String bounceType, @NotNull String feedbackId, @NotNull List<SesBouncedRecipient> bouncedRecipients) {
            Intrinsics.checkParameterIsNotNull((Object)bounceType, (String)"bounceType");
            Intrinsics.checkParameterIsNotNull((Object)feedbackId, (String)"feedbackId");
            Intrinsics.checkParameterIsNotNull(bouncedRecipients, (String)"bouncedRecipients");
            return new SesBounce(bounceType, feedbackId, bouncedRecipients);
        }

        @NotNull
        public static /* synthetic */ SesBounce copy$default(SesBounce sesBounce, String string, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = sesBounce.bounceType;
            }
            if ((n & 2) != 0) {
                string2 = sesBounce.feedbackId;
            }
            if ((n & 4) != 0) {
                list = sesBounce.bouncedRecipients;
            }
            return sesBounce.copy(string, string2, list);
        }

        @NotNull
        public String toString() {
            return "SesBounce(bounceType=" + this.bounceType + ", feedbackId=" + this.feedbackId + ", bouncedRecipients=" + this.bouncedRecipients + ")";
        }

        public int hashCode() {
            String string = this.bounceType;
            String string2 = this.feedbackId;
            List<SesBouncedRecipient> list = this.bouncedRecipients;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SesBounce)) break block3;
                    SesBounce sesBounce = (SesBounce)object;
                    if (!Intrinsics.areEqual((Object)this.bounceType, (Object)sesBounce.bounceType) || !Intrinsics.areEqual((Object)this.feedbackId, (Object)sesBounce.feedbackId) || !Intrinsics.areEqual(this.bouncedRecipients, sesBounce.bouncedRecipients)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$SesBouncedRecipient;", "", "emailAddress", "", "status", "diagnosticCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDiagnosticCode", "()Ljava/lang/String;", "getEmailAddress", "getStatus", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "youtrack-custom-notifications"})
    public static final class SesBouncedRecipient {
        @NotNull
        private final String emailAddress;
        @NotNull
        private final String status;
        @NotNull
        private final String diagnosticCode;

        @NotNull
        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        @NotNull
        public final String getDiagnosticCode() {
            return this.diagnosticCode;
        }

        public SesBouncedRecipient(@NotNull String emailAddress, @NotNull String status, @NotNull String diagnosticCode) {
            Intrinsics.checkParameterIsNotNull((Object)emailAddress, (String)"emailAddress");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticCode, (String)"diagnosticCode");
            this.emailAddress = emailAddress;
            this.status = status;
            this.diagnosticCode = diagnosticCode;
        }

        @NotNull
        public final String component1() {
            return this.emailAddress;
        }

        @NotNull
        public final String component2() {
            return this.status;
        }

        @NotNull
        public final String component3() {
            return this.diagnosticCode;
        }

        @NotNull
        public final SesBouncedRecipient copy(@NotNull String emailAddress, @NotNull String status, @NotNull String diagnosticCode) {
            Intrinsics.checkParameterIsNotNull((Object)emailAddress, (String)"emailAddress");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticCode, (String)"diagnosticCode");
            return new SesBouncedRecipient(emailAddress, status, diagnosticCode);
        }

        @NotNull
        public static /* synthetic */ SesBouncedRecipient copy$default(SesBouncedRecipient sesBouncedRecipient, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = sesBouncedRecipient.emailAddress;
            }
            if ((n & 2) != 0) {
                string2 = sesBouncedRecipient.status;
            }
            if ((n & 4) != 0) {
                string3 = sesBouncedRecipient.diagnosticCode;
            }
            return sesBouncedRecipient.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SesBouncedRecipient(emailAddress=" + this.emailAddress + ", status=" + this.status + ", diagnosticCode=" + this.diagnosticCode + ")";
        }

        public int hashCode() {
            String string = this.emailAddress;
            String string2 = this.status;
            String string3 = this.diagnosticCode;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SesBouncedRecipient)) break block3;
                    SesBouncedRecipient sesBouncedRecipient = (SesBouncedRecipient)object;
                    if (!Intrinsics.areEqual((Object)this.emailAddress, (Object)sesBouncedRecipient.emailAddress) || !Intrinsics.areEqual((Object)this.status, (Object)sesBouncedRecipient.status) || !Intrinsics.areEqual((Object)this.diagnosticCode, (Object)sesBouncedRecipient.diagnosticCode)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/notifications/awsses/BouncePollingScheduling$Companion;", "Lmu/KLogging;", "()V", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

