/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.cluster;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.notifications.AbstractNotificationCase;
import jetbrains.youtrack.api.notifications.NotificationComponentType;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationGroup;
import jetbrains.youtrack.api.notifications.NotificationHeader;
import jetbrains.youtrack.api.notifications.NotificationTemplateDescriptor;
import jetbrains.youtrack.event.persistent.XdEventKt;
import jetbrains.youtrack.notifications.accessData.IIssueChangeAdapter;
import jetbrains.youtrack.notifications.cluster.DigestClusterNotificationCase$WhenMappings;
import jetbrains.youtrack.notifications.main.TestDataUtilsKt;
import jetbrains.youtrack.notifications.sending.NotificationHeaderImpl;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="digestClusterNotificationCase")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Ljetbrains/youtrack/notifications/cluster/DigestClusterNotificationCase;", "Ljetbrains/youtrack/api/notifications/AbstractNotificationCase;", "()V", "auxiliaryTemplateDigestOverviewJabber", "Ljetbrains/youtrack/api/notifications/NotificationTemplateDescriptor;", "auxiliaryTemplateEvents", "auxiliaryTemplateFooter", "auxiliaryTemplateIssueHeader", "auxiliaryTemplateReasonJabber", "availableVariables", "", "", "getAvailableVariables", "()Ljava/util/Set;", "header", "Ljetbrains/youtrack/api/notifications/NotificationHeader;", "getHeader", "()Ljetbrains/youtrack/api/notifications/NotificationHeader;", "isCumulative", "", "()Z", "parent", "Ljetbrains/youtrack/api/notifications/NotificationGroup;", "getParent", "()Ljetbrains/youtrack/api/notifications/NotificationGroup;", "extendWithTestData", "", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "ctxIssue", "Ljetbrains/exodus/entitystore/Entity;", "recipient", "requiresTemplates", "", "type", "Ljetbrains/youtrack/api/notifications/NotificationComponentType;", "retrieveDataId", "Companion", "youtrack-custom-notifications"})
public final class DigestClusterNotificationCase
extends AbstractNotificationCase {
    @Autowired
    @Qualifier(value="auxiliaryTemplateIssueHeader")
    private NotificationTemplateDescriptor auxiliaryTemplateIssueHeader;
    @Autowired
    @Qualifier(value="auxiliaryTemplateEvents")
    private NotificationTemplateDescriptor auxiliaryTemplateEvents;
    @Autowired
    @Qualifier(value="auxiliaryTemplateFooter")
    private NotificationTemplateDescriptor auxiliaryTemplateFooter;
    @Autowired
    @Qualifier(value="auxiliaryTemplateDigestOverviewJabber")
    private NotificationTemplateDescriptor auxiliaryTemplateDigestOverviewJabber;
    @Autowired
    @Qualifier(value="auxiliaryTemplateReasonJabber")
    private NotificationTemplateDescriptor auxiliaryTemplateReasonJabber;
    private static final NotificationHeader CLUSTER_UPDATED;
    public static final Companion Companion;

    @NotNull
    public List<NotificationTemplateDescriptor> requiresTemplates(@NotNull NotificationComponentType type) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (DigestClusterNotificationCase$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object[] objectArray = new NotificationTemplateDescriptor[3];
                NotificationTemplateDescriptor notificationTemplateDescriptor = this.auxiliaryTemplateIssueHeader;
                if (notificationTemplateDescriptor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateIssueHeader");
                }
                objectArray[0] = notificationTemplateDescriptor;
                NotificationTemplateDescriptor notificationTemplateDescriptor2 = this.auxiliaryTemplateEvents;
                if (notificationTemplateDescriptor2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateEvents");
                }
                objectArray[1] = notificationTemplateDescriptor2;
                NotificationTemplateDescriptor notificationTemplateDescriptor3 = this.auxiliaryTemplateFooter;
                if (notificationTemplateDescriptor3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateFooter");
                }
                objectArray[2] = notificationTemplateDescriptor3;
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new NotificationTemplateDescriptor[2];
                NotificationTemplateDescriptor notificationTemplateDescriptor = this.auxiliaryTemplateDigestOverviewJabber;
                if (notificationTemplateDescriptor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateDigestOverviewJabber");
                }
                objectArray[0] = notificationTemplateDescriptor;
                NotificationTemplateDescriptor notificationTemplateDescriptor4 = this.auxiliaryTemplateReasonJabber;
                if (notificationTemplateDescriptor4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auxiliaryTemplateReasonJabber");
                }
                objectArray[1] = notificationTemplateDescriptor4;
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    @Nullable
    public NotificationGroup getParent() {
        String name$iv = "digestSchemeGroup";
        return (NotificationGroup)ServiceLocator.getBean((String)name$iv);
    }

    @NotNull
    public NotificationHeader getHeader() {
        return CLUSTER_UPDATED;
    }

    public void extendWithTestData(@NotNull NotificationData data, @NotNull Entity ctxIssue, @NotNull Entity recipient) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)ctxIssue, (String)"ctxIssue");
        Intrinsics.checkParameterIsNotNull((Object)recipient, (String)"recipient");
        XdIssue issue = (XdIssue)XdExtensionsKt.toXd((Entity)ctxIssue);
        XdUser to = (XdUser)XdExtensionsKt.toXd((Entity)recipient);
        if (!issue.isInDuplicateCluster()) {
            throw (Throwable)new IllegalArgumentException(BeansKt.getLocalizer().localizedMsg("NotificationTemplates.test.issue_is_not_in_duplicate_cluster", new Object[]{issue.getIdReadable()}));
        }
        LinkedList<IIssueChangeAdapter> changes = new LinkedList<IIssueChangeAdapter>();
        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)issue.getDuplicateCluster());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            XdIssue it = (XdIssue)element$iv;
            XdQuery events = XdEventKt.getPersistentEvents((XdEntity)((XdEntity)it));
            if (XdQueryKt.isEmpty((XdQuery)events)) {
                throw (Throwable)new IllegalArgumentException(BeansKt.getLocalizer().localizedMsg("NotificationTemplates.test.issue_has_no_events", new Object[]{issue.getIdReadable()}));
            }
            changes.add(TestDataUtilsKt.createTestChange(it));
        }
        IIssueChangeAdapter firstChange = (IIssueChangeAdapter)CollectionsKt.first((List)changes);
        Iterator $receiver = iterator = data;
        $receiver.set("issue", issue.getRootDuplicate());
        $receiver.set("header", this.getHeader().getValue());
        $receiver.set("to", recipient);
        $receiver.set("from", firstChange.getAuthor());
        $receiver.set("change", firstChange);
        $receiver.set("reason", TestDataUtilsKt.createTestReason(to, firstChange.getIssue()));
        $receiver.set("only_via_duplicate", true);
    }

    @NotNull
    public Set<String> getAvailableVariables() {
        return SetsKt.setOf((Object[])new String[]{"from", "to", "issue", "change", "reason", "only_via_duplicate", "changes"});
    }

    @Nullable
    public String retrieveDataId(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return null;
    }

    public boolean isCumulative() {
        return true;
    }

    public DigestClusterNotificationCase() {
        super("cluster_digest", "NotificationTemplates.Cluster_digest_title", "NotificationTemplates.Cluster_digest_description");
    }

    static {
        Companion = new Companion(null);
        CLUSTER_UPDATED = new NotificationHeaderImpl("UP_CL"){

            @NotNull
            public String getValue() {
                String string = BeansKt.getLocalizer().localizedMsg("ClusterDigestNotification.Updated", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026estNotification.Updated\")");
                return string;
            }
        };
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/notifications/cluster/DigestClusterNotificationCase$Companion;", "", "()V", "CLUSTER_UPDATED", "Ljetbrains/youtrack/api/notifications/NotificationHeader;", "youtrack-custom-notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

