/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.controller;

import freemarker.template.Configuration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.youtrack.notifications.controller.FreemarkerConfiguration;
import jetbrains.youtrack.notifications.controller.ProjectBasedNotificationFreemarkerConfiguration;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="notificationConfigurationProvider")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/notifications/controller/NotificationFreemarkerConfigurationProvider;", "", "()V", "defaultConfiguration", "Ljetbrains/youtrack/notifications/controller/FreemarkerConfiguration;", "getDefaultConfiguration", "()Ljetbrains/youtrack/notifications/controller/FreemarkerConfiguration;", "setDefaultConfiguration", "(Ljetbrains/youtrack/notifications/controller/FreemarkerConfiguration;)V", "projectConfigurations", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljetbrains/youtrack/persistent/XdProject;", "Lfreemarker/template/Configuration;", "addProject", "", "project", "getConfiguration", "hasConfiguration", "", "removeProject", "youtrack-custom-notifications"})
public class NotificationFreemarkerConfigurationProvider {
    private final ConcurrentHashMap<XdProject, Configuration> projectConfigurations = new ConcurrentHashMap();
    @Resource(name="defaultNotificationTemplateConfiguration")
    @NotNull
    public FreemarkerConfiguration defaultConfiguration;

    @NotNull
    public final FreemarkerConfiguration getDefaultConfiguration() {
        FreemarkerConfiguration freemarkerConfiguration = this.defaultConfiguration;
        if (freemarkerConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultConfiguration");
        }
        return freemarkerConfiguration;
    }

    public final void setDefaultConfiguration(@NotNull FreemarkerConfiguration freemarkerConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)freemarkerConfiguration), (String)"<set-?>");
        this.defaultConfiguration = freemarkerConfiguration;
    }

    @NotNull
    public final Configuration getConfiguration(@Nullable XdProject project) {
        Configuration configuration;
        if (project == null) {
            FreemarkerConfiguration freemarkerConfiguration = this.defaultConfiguration;
            if (freemarkerConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"defaultConfiguration");
            }
            configuration = freemarkerConfiguration;
        } else {
            configuration = this.projectConfigurations.get(project);
            if (configuration == null) {
                FreemarkerConfiguration freemarkerConfiguration = this.defaultConfiguration;
                if (freemarkerConfiguration == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"defaultConfiguration");
                }
                return freemarkerConfiguration;
            }
        }
        return configuration;
    }

    public final boolean hasConfiguration(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.projectConfigurations.get(project) != null;
    }

    public final void addProject(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Map map2 = this.projectConfigurations;
        ProjectBasedNotificationFreemarkerConfiguration projectBasedNotificationFreemarkerConfiguration = new ProjectBasedNotificationFreemarkerConfiguration(project);
        map2.put(project, projectBasedNotificationFreemarkerConfiguration);
    }

    public final void removeProject(@NotNull XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.projectConfigurations.remove(project);
    }
}

