/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.webr.ContainerAware;
import jetbrains.youtrack.event.merge.MergeMethodsKt;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import jetbrains.youtrack.notifications.analyzer.BeansKt;
import jetbrains.youtrack.notifications.analyzer.EventMergeAnalyzer;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

@LocalScoped
@ManagedResource
@Component(value="NotificationsSender")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J2\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/notifications/jmx/SecretNotificationSender;", "Ljetbrains/youtrack/api/webr/ContainerAware;", "()V", "container", "Lwebr/framework/controller/BeanContainer;", "getContainer", "()Lwebr/framework/controller/BeanContainer;", "eventMergeAnalyzer", "Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "getEventMergeAnalyzer", "()Ljetbrains/youtrack/notifications/analyzer/EventMergeAnalyzer;", "silentApplyEventMarker", "Ljetbrains/charisma/event/EventMarker;", "getSilentApplyEventMarker", "()Ljetbrains/charisma/event/EventMarker;", "systemApplyEventMarker", "getSystemApplyEventMarker", "findChanges", "", "", "", "", "from", "", "to", "sorted", "", "resendChanges", "Companion", "youtrack-custom-notifications"})
public class SecretNotificationSender
implements ContainerAware {
    @NotNull
    private final BeanContainer container;
    private static final DateTimeFormatter formatter;
    public static final Companion Companion;

    private final EventMarker getSilentApplyEventMarker() {
        String name$iv = "silentApplyEventMarker";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.event.EventMarker");
        }
        return (EventMarker)object;
    }

    private final EventMarker getSystemApplyEventMarker() {
        String name$iv = "systemApplyEventMarker";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.event.EventMarker");
        }
        return (EventMarker)object;
    }

    private final EventMergeAnalyzer getEventMergeAnalyzer() {
        String name$iv = "eventMergeAnalyzer";
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.notifications.analyzer.EventMergeAnalyzer");
        }
        return (EventMergeAnalyzer)object;
    }

    @NotNull
    public BeanContainer getContainer() {
        return this.container;
    }

    @ManagedOperation(description="Find issue changes, from and to should be formatted `yyyy-MM-dd HH:mm`")
    @NotNull
    public final Collection<Map<String, Object>> findChanges(@NotNull String from, @NotNull String to, boolean sorted) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return this.findChanges(formatter.parseMillis(from), formatter.parseMillis(to), sorted);
    }

    @ManagedOperation(description="Find issue changes. From and to are millis in UTC")
    @NotNull
    public final Collection<Map<String, Object>> findChanges(long from, long to, boolean sorted) {
        return (Collection)this.transactionalInScope((Function0)new Function0<Collection<? extends Map<String, ? extends Object>>>(from, to, sorted){
            final /* synthetic */ long $from;
            final /* synthetic */ long $to;
            final /* synthetic */ boolean $sorted;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<Map<String, Object>> invoke() {
                Collection collection;
                List list;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)MergeMethodsKt.getAllDirectEventMerges((long)this.$from, (long)this.$to);
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    Collection<String> collection2;
                    void $receiver$iv$iv2;
                    void $receiver$iv2;
                    void merge;
                    EventMerge eventMerge = (EventMerge)item$iv$iv;
                    Collection collection3 = destination$iv$iv;
                    Pair[] pairArray = new Pair[3];
                    Entity entity = merge.getAuthor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"merge.author");
                    pairArray[0] = TuplesKt.to((Object)"author", (Object)((XdUser)XdExtensionsKt.toXd((Entity)entity)).getVisibleName());
                    pairArray[1] = TuplesKt.to((Object)"timeStamp", (Object)merge.getLastTimestamp());
                    List list2 = merge.getProxyEvents();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"merge.proxyEvents");
                    Iterable iterable2 = list2;
                    String string = "debugInfo";
                    int n = 2;
                    Pair[] pairArray2 = pairArray;
                    Pair[] pairArray3 = pairArray;
                    void var12_12 = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (T item$iv$iv2 : $receiver$iv$iv2) {
                        void it;
                        Event event2 = (Event)item$iv$iv2;
                        collection2 = destination$iv$iv2;
                        String string2 = DebugInfoMethods.toDebugString((Event)it);
                        collection2.add(string2);
                    }
                    collection2 = (List)destination$iv$iv2;
                    pairArray2[n] = TuplesKt.to((Object)string, (Object)collection2);
                    Map map2 = MapsKt.mapOf((Pair[])pairArray3);
                    collection3.add(map2);
                }
                List it = list = (List)destination$iv$iv;
                if (this.$sorted) {
                    Iterable $receiver$iv3 = it;
                    Iterable iterable3 = $receiver$iv3;
                    Comparator comparator = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            Map it = (Map)a;
                            V v = it.get("timeStamp");
                            if (!(v instanceof Long)) {
                                v = null;
                            }
                            Long l = (Long)v;
                            it = (Map)b;
                            Comparable comparable = Long.valueOf(l != null ? l : -1L);
                            V v2 = it.get("timeStamp");
                            if (!(v2 instanceof Long)) {
                                v2 = null;
                            }
                            Long l2 = (Long)v2;
                            Long l3 = l2 != null ? l2 : -1L;
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l3);
                        }
                    };
                    collection = CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)comparator);
                } else {
                    collection = it;
                }
                return collection;
            }
            {
                this.$from = l;
                this.$to = l2;
                this.$sorted = bl;
                super(0);
            }
        });
    }

    @ManagedOperation(description="Resend found changes.From and to from and to should be formatted `yyyy-MM-dd HH:mm`")
    @NotNull
    public final String resendChanges(@NotNull String from, @NotNull String to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        return this.resendChanges(formatter.parseMillis(from), formatter.parseMillis(to));
    }

    @ManagedOperation(description="Resend found changes.From and to are millis in UTC")
    @NotNull
    public final String resendChanges(long from, long to) {
        return (String)this.transactionalInScope((Function0)new Function0<String>(this, from, to){
            final /* synthetic */ SecretNotificationSender this$0;
            final /* synthetic */ long $from;
            final /* synthetic */ long $to;

            @NotNull
            public final String invoke() {
                String string;
                List merges = MergeMethodsKt.getAllDirectEventMerges((long)this.$from, (long)this.$to);
                if (merges.isEmpty()) {
                    string = "No changes found!";
                } else {
                    byte silentApplyMarkerId = SecretNotificationSender.access$getSilentApplyEventMarker$p(this.this$0).getId();
                    byte adminActionMarkerId = SecretNotificationSender.access$getSystemApplyEventMarker$p(this.this$0).getId();
                    for (EventMerge merge : merges) {
                        byte marker;
                        Event lastEvent;
                        Event firstEvent;
                        Intrinsics.checkExpressionValueIsNotNull((Object)merge.getFirstEvent(), (String)"merge.firstEvent");
                        Intrinsics.checkExpressionValueIsNotNull((Object)merge.getLastEvent(), (String)"merge.lastEvent");
                        if (Intrinsics.areEqual((Object)firstEvent.getPrimaryEntity(), (Object)lastEvent.getPrimaryEntity()) && ((marker = lastEvent.getMarker()) == silentApplyMarkerId || marker == adminActionMarkerId)) continue;
                        SecretNotificationSender.access$getEventMergeAnalyzer$p(this.this$0).analyze(merge, false);
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Added about ").append(merges.size()).append(" to AnalyzeJobProcessor, new size is ");
                    Iterable iterable = BeansKt.getNotifyingAnalyzerJobProcessor().getPendingJobs();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"notifyingAnalyzerJobProcessor.pendingJobs");
                    string = stringBuilder.append(CollectionUtilKt.getSize((Iterable)iterable) + merges.size()).toString();
                }
                return string;
            }
            {
                this.this$0 = secretNotificationSender;
                this.$from = l;
                this.$to = l2;
                super(0);
            }
        });
    }

    public SecretNotificationSender() {
        BeanContainer beanContainer = WebLocalScope.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)beanContainer, (String)"WebLocalScope.getContainer()");
        this.container = beanContainer;
    }

    static {
        Companion = new Companion(null);
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");
        if (dateTimeFormatter == null) {
            Intrinsics.throwNpe();
        }
        formatter = dateTimeFormatter;
    }

    public <T> T transactionalInScope(@NotNull Function0<? extends T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return (T)ContainerAware.DefaultImpls.transactionalInScope((ContainerAware)this, action);
    }

    @NotNull
    public static final /* synthetic */ EventMarker access$getSilentApplyEventMarker$p(SecretNotificationSender $this) {
        return $this.getSilentApplyEventMarker();
    }

    @NotNull
    public static final /* synthetic */ EventMarker access$getSystemApplyEventMarker$p(SecretNotificationSender $this) {
        return $this.getSystemApplyEventMarker();
    }

    @NotNull
    public static final /* synthetic */ EventMergeAnalyzer access$getEventMergeAnalyzer$p(SecretNotificationSender $this) {
        return $this.getEventMergeAnalyzer();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/notifications/jmx/SecretNotificationSender$Companion;", "", "()V", "formatter", "Lorg/joda/time/format/DateTimeFormatter;", "youtrack-custom-notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

