/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.model;

import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.notifications.model.NullModel;
import jetbrains.youtrack.notifications.model.WikiWriterDecorator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J/\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/notifications/model/WikiDirectiveModel;", "Lfreemarker/template/TemplateDirectiveModel;", "context", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "execute", "", "environment", "Lfreemarker/core/Environment;", "params", "", "array", "", "Lfreemarker/template/TemplateModel;", "body", "Lfreemarker/template/TemplateDirectiveBody;", "(Lfreemarker/core/Environment;Ljava/util/Map;[Lfreemarker/template/TemplateModel;Lfreemarker/template/TemplateDirectiveBody;)V", "findParam", "", "name", "", "wrapper", "Lfreemarker/ext/beans/BeansWrapper;", "(Ljava/util/Map;Ljava/lang/String;Lfreemarker/ext/beans/BeansWrapper;)Ljava/lang/Boolean;", "Companion", "youtrack-custom-notifications"})
public final class WikiDirectiveModel
implements TemplateDirectiveModel {
    private final Entity context;
    @NotNull
    public static final String WIKI_DIRECTIVE_NAME = "wiki";
    @NotNull
    public static final String WIKI_PARAM_NAME = "markdown";
    public static final Companion Companion = new Companion(null);

    public void execute(@NotNull Environment environment, @NotNull Map<?, ?> params, @NotNull TemplateModel[] array, @Nullable TemplateDirectiveBody body) throws TemplateException, IOException {
        TemplateModel[] templateModelArray;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        TemplateModel[] templateModelArray2 = templateModelArray = array;
        if (!(templateModelArray2.length == 0)) {
            throw (Throwable)new TemplateModelException(WIKI_DIRECTIVE_NAME + BeansKt.getLocalizer().localizedMsg("notifications.directive_doesnt_allow_loop_variables", new Object[0]));
        }
        if (body == null) {
            throw (Throwable)new RuntimeException(BeansKt.getLocalizer().localizedMsg("WikiDirectiveModel.Missing_body_in_{0}_directive", new Object[]{WIKI_DIRECTIVE_NAME}));
        }
        Configuration configuration = environment.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"environment.configuration");
        ObjectWrapper objectWrapper = configuration.getObjectWrapper();
        if (objectWrapper == null) {
            throw new TypeCastException("null cannot be cast to non-null type freemarker.ext.beans.BeansWrapper");
        }
        BeansWrapper wrapper2 = (BeansWrapper)objectWrapper;
        Boolean isUsingMarkdown = this.findParam(params, WIKI_PARAM_NAME, wrapper2);
        Writer writer = environment.getOut();
        Intrinsics.checkExpressionValueIsNotNull((Object)writer, (String)"environment.out");
        body.render((Writer)new WikiWriterDecorator(writer, this.context, isUsingMarkdown));
    }

    private final Boolean findParam(Map<?, ?> params, String name, BeansWrapper wrapper2) throws TemplateModelException {
        if (params.isEmpty()) {
            return null;
        }
        Map<?, ?> map2 = params;
        Object value = map2.get(name);
        if (value == null || value instanceof NullModel) {
            throw (Throwable)new TemplateModelException(BeansKt.getLocalizer().localizedMsg("WikiDirectiveModel.The_{0}_parameter_missed", new Object[]{name}));
        }
        try {
            Object unwrappedValue;
            Object object = unwrappedValue = wrapper2.unwrap((TemplateModel)value);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            return (Boolean)object;
        }
        catch (Throwable t) {
            throw (Throwable)new TemplateModelException(BeansKt.getLocalizer().localizedMsg("WikiDirectiveModel.The_{0}_parameter_must_be_a_Boolean", new Object[]{name}));
        }
    }

    public WikiDirectiveModel(@Nullable Entity context) {
        this.context = context;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/notifications/model/WikiDirectiveModel$Companion;", "", "()V", "WIKI_DIRECTIVE_NAME", "", "WIKI_PARAM_NAME", "youtrack-custom-notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

