/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.sending;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdRemovedCustomFieldPrototype;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.event.adapter.NamedValue;
import jetbrains.youtrack.notifications.sending.AttachmentJSON;
import jetbrains.youtrack.notifications.sending.CustomFieldJSON;
import jetbrains.youtrack.notifications.sending.EntityValueJSON;
import jetbrains.youtrack.notifications.sending.NotificationJSON;
import jetbrains.youtrack.notifications.sending.PartialIssueJSON;
import jetbrains.youtrack.notifications.sending.PreRenderedNotificationJSON;
import jetbrains.youtrack.notifications.sending.SprintJSON;
import jetbrains.youtrack.notifications.sending.Value;
import jetbrains.youtrack.notifications.sending.ValueJSON;
import jetbrains.youtrack.notifications.sending.WorkItemJSON;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u0018\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J \u0010 \u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004*\u0004\u0018\u00010\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Ljetbrains/youtrack/notifications/sending/PersistentNotificationDataSerializer;", "Lmu/KLogging;", "()V", "attachment", "", "customFieldPrototype", "issue", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "removedFieldPrototype", "sprint", "workItem", "writer", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "asValue", "Ljetbrains/youtrack/notifications/sending/Value;", "Ljetbrains/youtrack/event/adapter/NamedValue;", "getAsValue$youtrack_custom_notifications", "(Ljetbrains/youtrack/event/adapter/NamedValue;)Ljetbrains/youtrack/notifications/sending/Value;", "str", "", "getStr$youtrack_custom_notifications", "(Ljava/lang/Object;)Ljava/lang/String;", "serialize", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "reason", "Ljetbrains/youtrack/api/notifications/NotificationReason;", "header", "subject", "body", "asEntityValue", "value", "Ljetbrains/exodus/entitystore/Entity;", "name", "youtrack-custom-notifications"})
public final class PersistentNotificationDataSerializer
extends KLogging {
    private static final String attachment;
    private static final String issue;
    private static final String sprint = "Sprint";
    private static final String customFieldPrototype;
    private static final String removedFieldPrototype;
    private static final String workItem = "IssueWorkItem";
    private static final ObjectMapper mapper;
    private static final ObjectWriter writer;
    public static final PersistentNotificationDataSerializer INSTANCE;

    @NotNull
    public final String serialize(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = writer.writeValueAsString((Object)new NotificationJSON(data.getRootMap()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.writeValueAsStrin\u2026cationJSON(data.rootMap))");
        return string;
    }

    @NotNull
    public final String serialize(@Nullable NotificationReason reason, @Nullable String header, @Nullable String subject, @Nullable String body) {
        String string = writer.writeValueAsString((Object)new PreRenderedNotificationJSON(reason, header, subject, body));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.writeValueAsStrin\u2026, header, subject, body))");
        return string;
    }

    @NotNull
    public final String getStr$youtrack_custom_notifications(@Nullable Object $receiver) {
        String string;
        Object object = $receiver;
        if (!(object instanceof String)) {
            object = null;
        }
        if ((string = (String)object) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final Value getAsValue$youtrack_custom_notifications(@NotNull NamedValue<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Object value = $receiver.getValue();
        String string = $receiver.getName();
        if (string == null) {
            string = "";
        }
        String name = string;
        Object object = value;
        return object instanceof Entity ? this.asEntityValue($receiver, (Entity)value, name) : (object instanceof XdEntity ? this.asEntityValue($receiver, ((XdEntity)value).getEntity(), name) : (Value)new ValueJSON(name));
    }

    private final Value asEntityValue(@NotNull NamedValue<?> $receiver, Entity value, String name) {
        Value value2;
        String string = value.getType();
        if (Intrinsics.areEqual((Object)string, (Object)attachment)) {
            String string2 = value.toIdString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value.toIdString()");
            value2 = new AttachmentJSON(name, string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)issue)) {
            value2 = new PartialIssueJSON(name, value);
        } else if (Intrinsics.areEqual((Object)string, (Object)sprint)) {
            value2 = new SprintJSON(name, value, null, 4, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)customFieldPrototype)) {
            value2 = new CustomFieldJSON($receiver, value);
        } else if (Intrinsics.areEqual((Object)string, (Object)removedFieldPrototype)) {
            value2 = new CustomFieldJSON($receiver, value);
        } else if (Intrinsics.areEqual((Object)string, (Object)workItem)) {
            value2 = new WorkItemJSON(name, value);
        } else {
            String string3 = value.toIdString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"value.toIdString()");
            value2 = new EntityValueJSON(name, string3);
        }
        return value2;
    }

    private PersistentNotificationDataSerializer() {
    }

    static {
        PersistentNotificationDataSerializer persistentNotificationDataSerializer;
        INSTANCE = persistentNotificationDataSerializer = new PersistentNotificationDataSerializer();
        attachment = XdIssueAttachment.Companion.getEntityType();
        issue = XdIssue.Companion.getEntityType();
        sprint = sprint;
        customFieldPrototype = XdCustomFieldPrototype.Companion.getEntityType();
        removedFieldPrototype = XdRemovedCustomFieldPrototype.Companion.getEntityType();
        workItem = workItem;
        mapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null)).configure(SerializationFeature.INDENT_OUTPUT, true);
        writer = mapper.writer();
    }
}

