/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.notifications.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jetbrains.youtrack.notifications.util.PlainTextUtil;
import jetbrains.youtrack.notifications.util.TableCell;
import jetbrains.youtrack.notifications.util.TableRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mu.KLogging;
import org.htmlparser.Node;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J\u0014\u0010\u0014\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J&\u0010\u0015\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0014\u0010\u0018\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/notifications/util/TableRenderer;", "", "util", "Ljetbrains/youtrack/notifications/util/PlainTextUtil;", "tableTag", "Lorg/htmlparser/tags/TableTag;", "(Ljetbrains/youtrack/notifications/util/PlainTextUtil;Lorg/htmlparser/tags/TableTag;)V", "myRows", "Ljava/util/ArrayList;", "", "Ljetbrains/youtrack/notifications/util/TableCell;", "getColumnCount", "", "getHeight", "row", "print", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "printColumnSeparator", "printLine", "tableCell", "lineNumber", "printRowSeparator", "Companion", "youtrack-custom-notifications"})
public final class TableRenderer {
    private final ArrayList<List<TableCell>> myRows;
    private final PlainTextUtil util;
    private static final String COLUMN_SEPARATOR = " ";
    private static final String ROW_SEPARATOR = "%n";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void print(@NotNull Appendable appendable) {
        Intrinsics.checkParameterIsNotNull((Object)appendable, (String)"appendable");
        int columnCount = this.getColumnCount();
        Iterator<List<TableCell>> iterator = this.myRows.iterator();
        block0: while (iterator.hasNext()) {
            List<TableCell> row;
            List<TableCell> list = row = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"row");
            int n = 0;
            int height = this.getHeight(list);
            int n2 = height - 1;
            if (n > n2) continue;
            while (true) {
                void lineNumber;
                int n3;
                int n4;
                if ((n4 = 0) <= (n3 = columnCount - 1)) {
                    while (true) {
                        void column;
                        TableCell cell = column < row.size() ? row.get((int)column) : null;
                        this.printLine(appendable, cell, (int)lineNumber);
                        this.printColumnSeparator(appendable);
                        if (column == n3) break;
                        ++column;
                    }
                }
                this.printRowSeparator(appendable);
                if (lineNumber == n2) continue block0;
                ++lineNumber;
            }
        }
    }

    private final int getHeight(List<TableCell> row) {
        Object v0;
        Iterable $receiver$iv = row;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            TableCell it = (TableCell)maxElem$iv;
            int maxValue$iv = it.getHeight();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                TableCell it2 = (TableCell)e$iv;
                int v$iv = it2.getHeight();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = maxElem$iv;
        }
        TableCell tableCell = v0;
        return tableCell != null ? tableCell.getHeight() : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int getColumnCount() {
        Object v0;
        Iterable $receiver$iv = this.myRows;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            void var3_3;
            Object maxElem$iv = iterator$iv.next();
            List it = (List)maxElem$iv;
            int maxValue$iv = it.size();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                List it2 = (List)e$iv;
                int v$iv = it2.size();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v0 = var3_3;
        }
        List list = v0;
        return list != null ? list.size() : 0;
    }

    private final void printLine(Appendable appendable, TableCell tableCell, int lineNumber) {
        try {
            if (tableCell != null && lineNumber < tableCell.getHeight()) {
                appendable.append(tableCell.getLine(lineNumber));
            }
        }
        catch (IOException e) {
            Companion.getLogger().error((Throwable)e, (Function0)printLine.1.INSTANCE);
        }
    }

    private final void printColumnSeparator(Appendable appendable) {
        try {
            appendable.append(COLUMN_SEPARATOR);
        }
        catch (IOException e) {
            Companion.getLogger().error((Throwable)e, (Function0)printColumnSeparator.1.INSTANCE);
        }
    }

    private final void printRowSeparator(Appendable appendable) {
        try {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = ROW_SEPARATOR;
            Object[] objectArray = new Object[]{};
            Appendable appendable2 = appendable;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            appendable2.append(string3);
        }
        catch (IOException e) {
            Companion.getLogger().error((Throwable)e, (Function0)printRowSeparator.1.INSTANCE);
        }
    }

    public TableRenderer(@NotNull PlainTextUtil util, @NotNull TableTag tableTag) {
        Intrinsics.checkParameterIsNotNull((Object)util, (String)"util");
        Intrinsics.checkParameterIsNotNull((Object)tableTag, (String)"tableTag");
        this.util = util;
        this.myRows = new ArrayList();
        for (TableRow tableRow : tableTag.getRows()) {
            Node[] $receiver$iv;
            ArrayList<TableCell> row = new ArrayList<TableCell>();
            this.myRows.add(row);
            TableRow tableRow2 = tableRow;
            Intrinsics.checkExpressionValueIsNotNull((Object)tableRow2, (String)"tableRow");
            Intrinsics.checkExpressionValueIsNotNull((Object)tableRow2.getChildrenAsNodeArray(), (String)"tableRow.childrenAsNodeArray");
            for (Node element$iv : $receiver$iv) {
                Node node2 = element$iv;
                if (!(node2 instanceof TableColumn) && !(node2 instanceof TableHeader)) continue;
                CompositeTag compositeTag = (CompositeTag)node2;
                String string = compositeTag.getChildrenHTML();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compositeTag.childrenHTML");
                String cellContent = this.util.toPlainText(string);
                TableCell cell = new TableCell(cellContent);
                row.add(cell);
            }
        }
    }

    static {
        COLUMN_SEPARATOR = COLUMN_SEPARATOR;
        ROW_SEPARATOR = ROW_SEPARATOR;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/notifications/util/TableRenderer$Companion;", "Lmu/KLogging;", "()V", "COLUMN_SEPARATOR", "", "ROW_SEPARATOR", "youtrack-custom-notifications"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

