/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.persistent;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.event.ChangeHandler;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.event.InMemoryEventType;
import jetbrains.charisma.event.InMemoryTransactionEventsData;
import jetbrains.exodus.database.LinkChange;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.event.persistent.ImportedEventFactory;
import jetbrains.youtrack.event.persistent.RealEventFactory;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.persistent.XdEventKt;
import jetbrains.youtrack.event.persistent.XdEventType;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdUndefinedUser;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 K*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001KB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016JI\u0010&\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00028\u00002\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\"\u001a\u00020#H\u0014\u00a2\u0006\u0002\u0010.J\u0015\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00101J\u0015\u00102\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00101J\u0015\u00103\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00101J\u0015\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00101J\u000e\u00108\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0007J\u0015\u00109\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00101J\u000e\u0010:\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0007J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0007H\u0014J\u0010\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020@H\u0016J%\u0010A\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020-H\u0014\u00a2\u0006\u0002\u0010DJ\u001f\u0010E\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010?\u001a\u00020@H&\u00a2\u0006\u0002\u0010FJ%\u0010G\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020-H\u0014\u00a2\u0006\u0002\u0010DJ\u000e\u0010J\u001a\u00020(*\u0004\u0018\u00010(H\u0002R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006L"}, d2={"Ljetbrains/youtrack/event/persistent/AbstractChangeHandler;", "V", "Lkotlinx/dnq/XdEntity;", "Ljetbrains/charisma/event/ChangeHandler;", "()V", "ignoredLinks", "", "", "getIgnoredLinks", "()Ljava/util/Set;", "ignoredProps", "getIgnoredProps", "importedEventFactory", "Ljetbrains/youtrack/event/persistent/ImportedEventFactory;", "getImportedEventFactory", "()Ljetbrains/youtrack/event/persistent/ImportedEventFactory;", "realEventFactory", "Ljetbrains/youtrack/event/persistent/RealEventFactory;", "getRealEventFactory", "()Ljetbrains/youtrack/event/persistent/RealEventFactory;", "strictMode", "", "getStrictMode", "()Z", "setStrictMode", "(Z)V", "getIssue", "Ljetbrains/youtrack/persistent/XdIssue;", "target", "(Lkotlinx/dnq/XdEntity;)Ljetbrains/youtrack/persistent/XdIssue;", "handle", "", "change", "Ljetbrains/exodus/database/TransientEntityChange;", "data", "Ljetbrains/charisma/event/InMemoryTransactionEventsData;", "marker", "Ljetbrains/charisma/event/EventMarker;", "handleLinkChange", "author", "Ljetbrains/youtrack/persistent/XdUser;", "linkName", "linkChange", "Ljetbrains/exodus/database/LinkChange;", "timestamp", "", "(Lkotlinx/dnq/XdEntity;Ljetbrains/youtrack/persistent/XdUser;Ljava/lang/String;Ljetbrains/exodus/database/LinkChange;JLjetbrains/charisma/event/EventMarker;Ljetbrains/charisma/event/InMemoryTransactionEventsData;)V", "hasNoRemoveEvent", "v", "(Lkotlinx/dnq/XdEntity;)Z", "isAlive", "isDeleted", "isFixedNewLinesProps", "propertyName", "isFixedNewLinesProps$youtrack_events", "isIgnored", "isLinkIgnored", "isNew", "isPropertyIgnored", "isStubChange", "memberName", "isUpdatingChange", "onUndefinedAuthorEvent", "event", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "setCreationTime", "createdBy", "created", "(Lkotlinx/dnq/XdEntity;Ljetbrains/youtrack/persistent/XdUser;J)V", "setIssue", "(Lkotlinx/dnq/XdEntity;Ljetbrains/youtrack/event/persistent/XdAbstractEvent;)Ljetbrains/youtrack/persistent/XdIssue;", "setUpdatingTime", "updatedBy", "updated", "orUndefinedUser", "Companion", "youtrack-events"})
public abstract class AbstractChangeHandler<V extends XdEntity>
implements ChangeHandler {
    private boolean strictMode;
    @NotNull
    private final RealEventFactory<V> realEventFactory = new RealEventFactory(this);
    @NotNull
    private final ImportedEventFactory<V> importedEventFactory = new ImportedEventFactory(this);
    public static final Companion Companion = new Companion(null);

    public final boolean getStrictMode() {
        return this.strictMode;
    }

    public final void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    @NotNull
    public final RealEventFactory<V> getRealEventFactory() {
        return this.realEventFactory;
    }

    @NotNull
    public final ImportedEventFactory<V> getImportedEventFactory() {
        return this.importedEventFactory;
    }

    @NotNull
    protected abstract Set<String> getIgnoredProps();

    @NotNull
    protected abstract Set<String> getIgnoredLinks();

    private final XdUser orUndefinedUser(@Nullable XdUser $receiver) {
        XdUser xdUser = $receiver;
        if (xdUser == null) {
            xdUser = (XdUser)XdUndefinedUser.Companion.get();
        }
        return xdUser;
    }

    public void handle(@NotNull TransientEntityChange change, @NotNull InMemoryTransactionEventsData data, @Nullable EventMarker marker) {
        XdUser author;
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        XdEntity v = XdExtensionsKt.toXd((Entity)((Entity)change.getTransientEntity()));
        if (v.isRemoved() || this.isIgnored(v)) {
            return;
        }
        long timestamp = data.getTimestamp();
        Entity entity = data.getAuthor();
        Object object = author = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (this.isNew(v)) {
            this.realEventFactory.newEvent(v, author, InMemoryEventType.ADD, timestamp, null, marker, data);
            this.setCreationTime(v, this.orUndefinedUser(author), timestamp);
        } else if (this.isAlive(v)) {
            Map changedLinksDetailed;
            TransientEntity oldVersion = change.getSnapshotEntity();
            TransientEntity newVersion = change.getTransientEntity();
            Set changedProperties = change.getChangedProperties();
            boolean wasUpdated = false;
            if (changedProperties != null) {
                List blobNames = null;
                for (String propName : changedProperties) {
                    if (this.isPropertyIgnored(propName)) continue;
                    if (this.isStubChange(propName)) {
                        this.realEventFactory.newEvent(v, author, InMemoryEventType.MODIFY_STUB, timestamp, propName, marker, data);
                    } else {
                        boolean isBlob;
                        if (blobNames == null) {
                            blobNames = oldVersion.getBlobNames();
                        }
                        Comparable oldValue = (isBlob = blobNames.contains(propName)) ? (Comparable)((Object)oldVersion.getBlobString(propName)) : oldVersion.getProperty(propName);
                        Comparable newValue = isBlob ? (Comparable)((Object)newVersion.getBlobString(propName)) : newVersion.getProperty(propName);
                        this.realEventFactory.newPropertyEvent(v, author, propName, oldValue, newValue, timestamp, marker, data);
                    }
                    wasUpdated = wasUpdated || this.isUpdatingChange(propName);
                }
            }
            if ((changedLinksDetailed = change.getChangedLinksDetailed()) != null) {
                for (LinkChange linkChange : changedLinksDetailed.values()) {
                    String linkName = linkChange.getLinkName();
                    if (this.isLinkIgnored(linkName)) continue;
                    if (this.isStubChange(linkName)) {
                        this.realEventFactory.newEvent(v, author, InMemoryEventType.MODIFY_STUB, timestamp, linkName, marker, data);
                    } else {
                        if (linkChange.getRemovedEntitiesSize() == 0 && linkChange.getAddedEntitiesSize() == 0) continue;
                        this.handleLinkChange(v, author, linkName, linkChange, timestamp, marker, data);
                    }
                    wasUpdated = wasUpdated || this.isUpdatingChange(linkName);
                }
            }
            if (wasUpdated) {
                this.setUpdatingTime(v, this.orUndefinedUser(author), timestamp);
            }
        } else if (this.isDeleted(v) && this.hasNoRemoveEvent(v)) {
            this.realEventFactory.newEvent(v, author, InMemoryEventType.REMOVE, timestamp, null, marker, data);
        }
    }

    private final boolean hasNoRemoveEvent(V v) {
        XdAbstractEvent lastEvent = (XdAbstractEvent)((Object)SequencesKt.lastOrNull((Sequence)XdQueryKt.asSequence(XdEventKt.getPersistentEvents(v))));
        return lastEvent == null || Intrinsics.areEqual((Object)((Object)lastEvent.getType()), (Object)((Object)XdEventType.Companion.getREMOVE())) ^ true;
    }

    public final boolean isPropertyIgnored(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return this.getIgnoredProps().contains(propertyName) || StringsKt.startsWith$default((String)propertyName, (String)"__PARENT_TO_CHILD_LINK_NAME__", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)propertyName, (String)"__CHILD_TO_PARENT_LINK_NAME__", (boolean)false, (int)2, null);
    }

    public final boolean isLinkIgnored(@NotNull String linkName) {
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        return this.getIgnoredLinks().contains(linkName);
    }

    protected void handleLinkChange(@NotNull V target, @Nullable XdUser author, @NotNull String linkName, @NotNull LinkChange linkChange, long timestamp, @Nullable EventMarker marker, @NotNull InMemoryTransactionEventsData data) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull((Object)linkChange, (String)"linkChange");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.realEventFactory.newLinkEvent(target, author, linkName, linkChange.getRemovedEntities(), linkChange.getAddedEntities(), timestamp, marker, data);
    }

    @Nullable
    protected abstract XdIssue getIssue(@NotNull V var1);

    @Nullable
    public abstract XdIssue setIssue(@NotNull V var1, @NotNull XdAbstractEvent var2);

    protected abstract boolean isNew(@NotNull V var1);

    protected void setCreationTime(@NotNull V target, @NotNull XdUser createdBy, long created) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)createdBy, (String)"createdBy");
    }

    protected void setUpdatingTime(@NotNull V target, @NotNull XdUser updatedBy, long updated) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)updatedBy, (String)"updatedBy");
    }

    protected boolean isUpdatingChange(@NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        return true;
    }

    public boolean isStubChange(@NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        return false;
    }

    public boolean isFixedNewLinesProps$youtrack_events(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return false;
    }

    protected abstract boolean isAlive(@NotNull V var1);

    protected abstract boolean isDeleted(@NotNull V var1);

    protected abstract boolean isIgnored(@NotNull V var1);

    public void onUndefinedAuthorEvent(@NotNull XdAbstractEvent event2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event2), (String)"event");
        String msg = "Created " + this.getTypeName() + " event " + event2.toDebugString() + " with undefined author";
        if (this.strictMode) {
            throw (Throwable)new RuntimeException(msg);
        }
        Companion.getLogger().warn(msg);
        Companion.getLogger().debug(msg, (Throwable)new RuntimeException("Trace event source"));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/event/persistent/AbstractChangeHandler$Companion;", "Lmu/KLogging;", "()V", "youtrack-events"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

