/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.AssociationType;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.query.metadata.ModelMetaDataImpl;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.IVcDiffCoder;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractPersistentEventImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "AbstractPersistentEvent";
    public static final String OLD_VALUE_PROP_NAME = "oldValue";
    public static final String DELTA_VALUE_BLOB_NAME = "deltaValue";
    public static final String ADDED_LINK_NAME = "added";
    public static final String REMOVED_LINK_NAME = "removed";
    public static final String TARGET_LINK_NAME = "target";
    protected static Log log = LogFactory.getLog(AbstractPersistentEventImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        return entity;
    }

    public String getTypePrefix(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    private Iterable<Entity> getToManyAlive(String linkName, Entity entity) {
        return Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)linkName)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.equals((Entity)it, null) && !EntityOperations.isRemoved((Entity)it);
            }
        });
    }

    @NotNull
    public Iterable<Entity> getRemovedLinks(Entity entity) {
        List linkNames = entity.getLinkNames();
        for (String linkName : linkNames) {
            if (!linkName.startsWith(REMOVED_LINK_NAME)) continue;
            return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getToManyAlive(linkName, entity);
        }
        return EntityIterableBase.EMPTY;
    }

    void setRemovedLinks(@Nullable Iterable<? extends Entity> entities, Entity entity) {
        if (entities == null) {
            return;
        }
        Iterator itr = Sequence.fromIterable(entities).iterator();
        if (itr.hasNext()) {
            Entity removedEntity = (Entity)itr.next();
            String linkName = AbstractPersistentEventImpl.getRemovedLinkName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"memberName", String.class, null));
            AbstractPersistentEventImpl.registerLinkAssociation(linkName, removedEntity.getType(), removedEntity);
            while (true) {
                DirectedAssociationSemantics.createToMany((Entity)entity, (String)linkName, (Entity)removedEntity);
                if (!itr.hasNext()) break;
                removedEntity = (Entity)itr.next();
            }
        }
    }

    void clearRemovedLinks(Entity entity) {
        String linkName = AbstractPersistentEventImpl.getRemovedLinkName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"memberName", String.class, null));
        DirectedAssociationSemantics.clearToMany((Entity)entity, (String)linkName);
    }

    @NotNull
    public Iterable<Entity> getAddedLinks(Entity entity) {
        List linkNames = entity.getLinkNames();
        for (String linkName : linkNames) {
            if (!linkName.startsWith(ADDED_LINK_NAME)) continue;
            return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getToManyAlive(linkName, entity);
        }
        return EntityIterableBase.EMPTY;
    }

    void setAddedLinks(@Nullable Iterable<? extends Entity> entities, Entity entity) {
        if (entities == null) {
            return;
        }
        Iterator itr = Sequence.fromIterable(entities).iterator();
        if (itr.hasNext()) {
            Entity addedEntity = (Entity)itr.next();
            String linkName = AbstractPersistentEventImpl.getAddedLinkName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"memberName", String.class, null));
            AbstractPersistentEventImpl.registerLinkAssociation(linkName, addedEntity.getType(), addedEntity);
            while (true) {
                DirectedAssociationSemantics.createToMany((Entity)entity, (String)linkName, (Entity)addedEntity);
                if (!itr.hasNext()) break;
                addedEntity = (Entity)itr.next();
            }
        }
    }

    void clearAddedLinks(Entity entity) {
        String linkName = AbstractPersistentEventImpl.getAddedLinkName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"memberName", String.class, null));
        DirectedAssociationSemantics.clearToMany((Entity)entity, (String)linkName);
    }

    public boolean isPropertyChange(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"type"), (Object)EventTypeImpl.MODIFY_PROPERTY.get());
    }

    @NotNull
    public Entity getTarget(Entity entity) {
        Entity target = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getNullableTarget(entity);
        if (EntityOperations.equals((Entity)target, null)) {
            String msg = entity.toIdString() + " has undefined target " + ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getTargetPersistentClass(entity);
            throw new IllegalStateException(msg);
        }
        return target;
    }

    public String getTargetPersistentClass(Entity entity) {
        String issueTargetLinkName = AbstractPersistentEventImpl.getTargetAssociationName("Issue");
        for (String linkName : entity.getLinkNames()) {
            if (!linkName.startsWith(TARGET_LINK_NAME) || linkName.equals(issueTargetLinkName)) continue;
            return linkName.substring(TARGET_LINK_NAME.length());
        }
        return "Issue";
    }

    @Nullable
    public Entity getNullableTarget(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getActualTargetLinkName(entity));
    }

    public String getActualTargetLinkName(Entity entity) {
        String issueTargetLinkName = AbstractPersistentEventImpl.getTargetAssociationName("Issue");
        for (String linkName : entity.getLinkNames()) {
            if (!linkName.startsWith(TARGET_LINK_NAME) || linkName.equals(issueTargetLinkName)) continue;
            return linkName;
        }
        return issueTargetLinkName;
    }

    public void setTarget(Entity newTarget, Entity entity) {
        String targetPersistentType = newTarget.getType();
        String targetAssociationName = AbstractPersistentEventImpl.getTargetAssociationName(targetPersistentType);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)targetAssociationName, (Entity)newTarget);
    }

    public Entity getIssue(Entity entity) {
        String issueTargetLinkName = AbstractPersistentEventImpl.getTargetAssociationName("Issue");
        return DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)entity, (String)issueTargetLinkName), (String)"Issue");
    }

    public void setIssue(Entity issue, Entity entity) {
        ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).setTarget(issue, entity);
    }

    public void clearTarget(Entity entity) {
        String targetAssociationName = AbstractPersistentEventImpl.getTargetAssociationName(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getTarget(entity).getType());
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)targetAssociationName, null);
    }

    public void resetTarget(Entity newTarget, Entity entity) {
        ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).clearTarget(entity);
        ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).setTarget(newTarget, entity);
    }

    public long getId(Entity entity) {
        return entity.getId().getLocalId();
    }

    public Comparable getOldPropertyValue(Comparable newValue, Entity entity) {
        InputStream deltaStream = PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)DELTA_VALUE_BLOB_NAME);
        if (deltaStream != null) {
            if (newValue == null) {
                throw new RuntimeException("Trial to decode null value");
            }
            return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).decode((String)((Object)newValue), deltaStream, entity);
        }
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).getOldPropertyDirectly(entity);
    }

    public boolean hasDeltaPropertyValue(Entity entity) {
        return PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)DELTA_VALUE_BLOB_NAME) != null;
    }

    public boolean isDeltaEncoded(Entity entity) {
        return PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)DELTA_VALUE_BLOB_NAME) != null;
    }

    public void setOldPropertyDirectly(Comparable value, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)OLD_VALUE_PROP_NAME, (Comparable)value);
    }

    public Comparable getOldPropertyDirectly(Entity entity) {
        return (Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)OLD_VALUE_PROP_NAME, null);
    }

    public Comparable getOldPropertyDirectly(Class<?> propertyType, Entity entity) {
        return (Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)OLD_VALUE_PROP_NAME, propertyType, null);
    }

    public InputStream getDeltaBlob(Entity entity) {
        return PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)DELTA_VALUE_BLOB_NAME);
    }

    public void setDeltaBlob(InputStream blob, Entity entity) {
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)DELTA_VALUE_BLOB_NAME, (InputStream)blob);
    }

    public void setPropertyChange(@Nullable Comparable oldValue, @Nullable Comparable newValue, Entity entity) {
        if (oldValue == null || newValue == null || !(oldValue instanceof String)) {
            ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).setOldPropertyDirectly(oldValue, entity);
        } else {
            LightByteArrayOutputStream deltaStream = new LightByteArrayOutputStream();
            boolean succed = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).encode((String)((Object)oldValue), (String)((Object)newValue), (OutputStream)deltaStream, entity);
            if (succed) {
                ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).setDeltaBlob(new ByteArrayInputStream(deltaStream.toByteArray(), 0, deltaStream.size()), entity);
            } else {
                ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"AbstractPersistentEvent")).setOldPropertyDirectly(oldValue, entity);
            }
        }
    }

    private boolean encode(@NotNull String oldValue, @NotNull String newValue, OutputStream output, Entity entity) {
        try {
            return ((IVcDiffCoder)ServiceLocator.getBean((String)"vcDiffCoder")).encode(oldValue, newValue, output);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not count property delta for persistent event " + DebugInfoMethods.toDebugString(entity), ioe);
        }
    }

    public String decode(@NotNull String newValue, InputStream deltaStream, Entity entity) {
        try {
            return ((IVcDiffCoder)ServiceLocator.getBean((String)"vcDiffCoder")).decode(newValue, deltaStream);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException("Could not decode vcdiff", iae);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not decode vcdiff", ioe);
        }
    }

    static Entity constructor() {
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Iterable<Entity> byTargetType(Iterable<Entity> events2, String targetType) {
        String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName(targetType);
        return QueryOperations.query(events2, (String)"AbstractPersistentEvent", (NodeBase)new LinkNotNull(targetLinkName));
    }

    public static Iterable<Entity> getTargetIssues(Iterable<Entity> events2) {
        String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName("Issue");
        return QueryOperations.selectManyDistinct(events2, (String)targetLinkName);
    }

    public static String getAddedLinkName(String memberName) {
        return "added_" + memberName;
    }

    public static String getRemovedLinkName(String memberName) {
        return "removed_" + memberName;
    }

    public static boolean isAddedOrRemovedLinkName(@NotNull String linkName) {
        return linkName.startsWith(ADDED_LINK_NAME) || linkName.startsWith(REMOVED_LINK_NAME);
    }

    public static String getTargetAssociationName(String targetPersistentType) {
        return "target_" + targetPersistentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTargetAssociation(String targetPersistentType) {
        ModelMetaDataImpl mmd;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered constraint for association: AbstractPersistentEvent to " + targetPersistentType));
        }
        String targetAssociationName = AbstractPersistentEventImpl.getTargetAssociationName(targetPersistentType);
        ModelMetaDataImpl modelMetaDataImpl = mmd = (ModelMetaDataImpl)((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData"));
        synchronized (modelMetaDataImpl) {
            if (!mmd.hasAssociation("AbstractPersistentEvent", targetPersistentType, targetAssociationName)) {
                mmd.addAssociation("AbstractPersistentEvent", targetPersistentType, AssociationType.Directed, targetAssociationName, AssociationEndCardinality._0_1, false, true, true, true, null, null, false, false, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLinkAssociation(String associationName, String linkedEntityPeristentType, @Nullable Entity targetEntity) {
        ModelMetaDataImpl mmd = (ModelMetaDataImpl)((ModelMetaData)ServiceLocator.getBean((String)"modelMetaData"));
        if (mmd.getEntityMetaData(linkedEntityPeristentType) == null) {
            String targetEntityInfo;
            String string = targetEntityInfo = EntityOperations.equals((Entity)targetEntity, null) ? "" : " in " + targetEntity.toIdString();
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not register association " + associationName + "[AbstractPersistentEvent->" + linkedEntityPeristentType + "]" + targetEntityInfo + ", no " + linkedEntityPeristentType + " entity type info"));
            }
        } else {
            ModelMetaDataImpl modelMetaDataImpl = mmd;
            synchronized (modelMetaDataImpl) {
                if (!mmd.hasAssociation("AbstractPersistentEvent", linkedEntityPeristentType, associationName)) {
                    mmd.addAssociation("AbstractPersistentEvent", linkedEntityPeristentType, AssociationType.Directed, associationName, AssociationEndCardinality._0_n, false, true, false, true, null, null, false, false, false, false);
                }
            }
        }
    }
}

