/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.persistent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.MediaType;
import jetbrains.youtrack.event.persistent.EventConsumerImpl;
import jetbrains.youtrack.event.persistent.EventConsumerListener;
import jetbrains.youtrack.event.persistent.InMemoryEvent;
import jetbrains.youtrack.event.persistent.PingHandler;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="eventConsumer")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0007J\b\u0010\u0017\u001a\u00020\u0011H\u0007J\u0014\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8B@CX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/event/persistent/EventConsumerImpl;", "", "()V", "listenerState", "", "Ljetbrains/youtrack/event/persistent/EventConsumerListener;", "Ljetbrains/youtrack/event/persistent/EventConsumerImpl$State;", "value", "", "listeners", "setListeners", "(Ljava/util/List;)V", "thread", "Ljava/lang/Thread;", "getThread", "()Ljava/lang/Thread;", "pingAll", "", "spinWaitFor", "listener", "sequence", "", "start", "stop", "subscribe", "disruptor", "Lcom/lmax/disruptor/dsl/Disruptor;", "Ljetbrains/youtrack/event/persistent/InMemoryEvent;", "Companion", "PingEvent", "State", "youtrack-events"})
public final class EventConsumerImpl {
    private List<? extends EventConsumerListener> listeners;
    private Map<EventConsumerListener, State> listenerState;
    @NotNull
    private final Thread thread;
    private static final int PING_TIMEOUT = 30000;
    @NotNull
    private static final OutboundEvent pingEvent;
    @NotNull
    private static final OutboundEvent namedPingEvent;
    public static final Companion Companion;

    @Autowired(required=false)
    private final void setListeners(List<? extends EventConsumerListener> value) {
        this.listeners = value;
        this.listenerState.clear();
        Iterable $receiver$iv = value;
        for (Object element$iv : $receiver$iv) {
            EventConsumerListener it = (EventConsumerListener)element$iv;
            Map<EventConsumerListener, State> map = this.listenerState;
            State state = new State(it);
            map.put(it, state);
        }
    }

    @NotNull
    public final Thread getThread() {
        return this.thread;
    }

    @PostConstruct
    public final void start() {
        if (!Boolean.getBoolean("jetbrains.youtrack.event.disablePing")) {
            this.thread.start();
        }
    }

    @PreDestroy
    public final void stop() {
        this.thread.interrupt();
    }

    public final void spinWaitFor(@NotNull EventConsumerListener listener, long sequence) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            State state = this.listenerState.get(listener);
            if (state == null) break block0;
            state.spinWaitFor(sequence);
        }
    }

    public final void pingAll() {
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            EventConsumerListener it = (EventConsumerListener)element$iv;
            Iterable $receiver$iv2 = it.getPingHandlers();
            for (Object element$iv2 : $receiver$iv2) {
                PingHandler it2 = (PingHandler)element$iv2;
                try {
                    it2.handlePing();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void subscribe(@NotNull Disruptor<InMemoryEvent> disruptor) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(disruptor, (String)"disruptor");
        Collection<State> collection = this.listenerState.values();
        Disruptor<InMemoryEvent> disruptor2 = disruptor;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        State[] stateArray = thisCollection$iv.toArray(new State[0]);
        if (stateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        State[] stateArray2 = stateArray;
        EventHandler[] eventHandlerArray = (EventHandler[])stateArray2;
        disruptor2.handleEventsWith(Arrays.copyOf(eventHandlerArray, eventHandlerArray.length)).then(new EventHandler[]{subscribe.1.INSTANCE});
    }

    public EventConsumerImpl() {
        EventConsumerImpl eventConsumerImpl = this;
        Object object = CollectionsKt.emptyList();
        eventConsumerImpl.listeners = object;
        eventConsumerImpl = this;
        eventConsumerImpl.listenerState = object = (Map)new LinkedHashMap();
        this.thread = new Thread(null, new Runnable(this){
            final /* synthetic */ EventConsumerImpl this$0;

            public final void run() {
                try {
                    while (true) {
                        Thread thread2 = Thread.currentThread();
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread2, (String)"Thread.currentThread()");
                        if (!thread2.isInterrupted()) {
                            long nextPing = EventConsumerImpl.Companion.getNow() + (long)EventConsumerImpl.Companion.getPING_TIMEOUT();
                            this.this$0.pingAll();
                            long wait = nextPing - EventConsumerImpl.Companion.getNow();
                            if (wait <= 0L) continue;
                            Thread.sleep(wait);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            {
                this.this$0 = eventConsumerImpl;
            }
        }, "SSE Ping");
    }

    static {
        OutboundEvent.Builder builder;
        Companion = new Companion(null);
        PING_TIMEOUT = 30000;
        OutboundEvent.Builder $receiver = builder = new OutboundEvent.Builder();
        $receiver.mediaType(MediaType.APPLICATION_JSON_TYPE);
        $receiver.data(PingEvent.class, (Object)PingEvent.INSTANCE);
        OutboundEvent outboundEvent = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)outboundEvent, (String)"OutboundEvent.Builder().\u2026gEvent)\n        }.build()");
        pingEvent = outboundEvent;
        $receiver = builder = new OutboundEvent.Builder();
        $receiver.mediaType(MediaType.APPLICATION_JSON_TYPE);
        $receiver.name(PingEvent.INSTANCE.getEventType());
        $receiver.data(PingEvent.class, (Object)PingEvent.INSTANCE);
        OutboundEvent outboundEvent2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)outboundEvent2, (String)"OutboundEvent.Builder().\u2026gEvent)\n        }.build()");
        namedPingEvent = outboundEvent2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/event/persistent/EventConsumerImpl$PingEvent;", "", "()V", "eventType", "", "getEventType", "()Ljava/lang/String;", "youtrack-events"})
    public static final class PingEvent {
        @NotNull
        private static final String eventType = "ping";
        public static final PingEvent INSTANCE;

        @NotNull
        public final String getEventType() {
            return eventType;
        }

        private PingEvent() {
        }

        static {
            PingEvent pingEvent;
            INSTANCE = pingEvent = new PingEvent();
            eventType = eventType;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/event/persistent/EventConsumerImpl$State;", "Lcom/lmax/disruptor/SequenceReportingEventHandler;", "Ljetbrains/youtrack/event/persistent/InMemoryEvent;", "listener", "Ljetbrains/youtrack/event/persistent/EventConsumerListener;", "(Ljetbrains/youtrack/event/persistent/EventConsumerImpl;Ljetbrains/youtrack/event/persistent/EventConsumerListener;)V", "getListener", "()Ljetbrains/youtrack/event/persistent/EventConsumerListener;", "sequence", "Lcom/lmax/disruptor/Sequence;", "getSequence", "()Lcom/lmax/disruptor/Sequence;", "setSequence", "(Lcom/lmax/disruptor/Sequence;)V", "onEvent", "", "event", "", "endOfBatch", "", "setSequenceCallback", "spinWaitFor", "youtrack-events"})
    private final class State
    implements SequenceReportingEventHandler<InMemoryEvent> {
        @NotNull
        public volatile Sequence sequence;
        @NotNull
        private final EventConsumerListener listener;

        public void onEvent(@NotNull InMemoryEvent event2, long sequence, boolean endOfBatch) {
            Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
            try {
                this.listener.invoke(event2);
            }
            catch (Throwable t) {
                Companion.getLogger().warn(t, (Function0)onEvent.1.INSTANCE);
            }
        }

        @NotNull
        public final Sequence getSequence() {
            Sequence sequence = this.sequence;
            if (sequence == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sequence");
            }
            return sequence;
        }

        public final void setSequence(@NotNull Sequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"<set-?>");
            this.sequence = sequence;
        }

        public void setSequenceCallback(@NotNull Sequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            this.sequence = sequence;
        }

        public final void spinWaitFor(long sequence) {
            while (true) {
                Sequence sequence2 = this.sequence;
                if (sequence2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sequence");
                }
                if (sequence <= sequence2.get()) break;
                Thread.sleep(100L);
            }
        }

        @NotNull
        public final EventConsumerListener getListener() {
            return this.listener;
        }

        public State(EventConsumerListener listener) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            this.listener = listener;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/event/persistent/EventConsumerImpl$Companion;", "Lmu/KLogging;", "()V", "PING_TIMEOUT", "", "getPING_TIMEOUT", "()I", "namedPingEvent", "Lorg/glassfish/jersey/media/sse/OutboundEvent;", "getNamedPingEvent", "()Lorg/glassfish/jersey/media/sse/OutboundEvent;", "now", "", "getNow", "()J", "pingEvent", "getPingEvent", "youtrack-events"})
    public static final class Companion
    extends KLogging {
        public final long getNow() {
            return System.currentTimeMillis();
        }

        public final int getPING_TIMEOUT() {
            return PING_TIMEOUT;
        }

        @NotNull
        public final OutboundEvent getPingEvent() {
            return pingEvent;
        }

        @NotNull
        public final OutboundEvent getNamedPingEvent() {
            return namedPingEvent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

