/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventSequenceTypeImpl;
import jetbrains.youtrack.event.persistent.InMemoryEventSequenceType;
import jetbrains.youtrack.event.rollback.SingleEvent;
import org.jetbrains.annotations.Nullable;

public class EventMethods {
    public static Iterable<Entity> getPersistentEventsDirect(Entity _this, @Nullable NodeBase node) {
        String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName(_this.getType());
        LinkEqual requestedNode = node == null ? new LinkEqual(targetLinkName, _this) : new And((NodeBase)new LinkEqual(targetLinkName, _this), node);
        return QueryOperations.query(null, (String)"PersistentEvent", (NodeBase)requestedNode);
    }

    public static Iterable<Event> getEventsDirect(Entity _this) {
        return Sequence.fromIterable(EventMethods.getPersistentEventsDirect(_this, null)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, Event>(){

            public Event select(Entity it) {
                return new SingleEvent(it);
            }
        });
    }

    public static Iterable<Entity> getImportedPersistentEventsDirect(Entity _this, @Nullable NodeBase node) {
        String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName(_this.getType());
        LinkEqual requestedNode = node == null ? new LinkEqual(targetLinkName, _this) : new And((NodeBase)new LinkEqual(targetLinkName, _this), node);
        return QueryOperations.query(null, (String)"ImportedPersistentEvent", (NodeBase)requestedNode);
    }

    private static Iterable<Entity> getSortedAbstractPersistentEvents(Entity _this, @Nullable NodeBase node, boolean asc) {
        String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName(_this.getType());
        And effectiveNode = node != null ? new And((NodeBase)new LinkEqual(targetLinkName, _this), node) : new LinkEqual(targetLinkName, _this);
        return QueryOperations.query((Iterable)QueryOperations.query(null, (String)"AbstractPersistentEvent", (NodeBase)effectiveNode), (String)"AbstractPersistentEvent", (NodeBase)new SortByProperty(null, "timestamp", asc));
    }

    public static Iterable<Entity> getAbstractPersistentEventsReversed(Entity _this, @Nullable NodeBase node) {
        Entity sType = EventMethods.getEventSequenceType(_this);
        if (EntityOperations.equals((Entity)sType, null)) {
            return QueryOperations.reverse(EventMethods.getPersistentEventsDirect(_this, node));
        }
        Iterable reversedEvents = null;
        if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.ONLY_IMPORTED.get())) {
            reversedEvents = QueryOperations.reverse(EventMethods.getImportedPersistentEventsDirect(_this, node));
        } else if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get())) {
            Iterable reversedHead = QueryOperations.reverse(EventMethods.getImportedPersistentEventsDirect(_this, node));
            Iterable reversedTail = QueryOperations.reverse(EventMethods.getPersistentEventsDirect(_this, node));
            reversedEvents = QueryOperations.concat((Iterable)reversedTail, (Iterable)reversedHead);
        } else if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.LAYERED.get())) {
            reversedEvents = EventMethods.getSortedAbstractPersistentEvents(_this, node, false);
        }
        return reversedEvents;
    }

    public static Iterable<Entity> getAbstractPersistentEventsDirect(Entity _this) {
        return (Iterable)EventMethods.getAllPersistentEventsDirect(_this, null).getFirst();
    }

    public static Iterable<Entity> getAbstractPersistentEventsDirect(Entity _this, @Nullable NodeBase node) {
        return (Iterable)EventMethods.getAllPersistentEventsDirect(_this, node).getFirst();
    }

    public static Pair<Iterable<Entity>, InMemoryEventSequenceType> getAllPersistentEventsDirect(Entity _this, @Nullable NodeBase node) {
        InMemoryEventSequenceType type;
        Iterable directEvents;
        Entity sType = EventMethods.getEventSequenceType(_this);
        if (EntityOperations.equals((Entity)sType, null)) {
            return new Pair(EventMethods.getPersistentEventsDirect(_this, node), (Object)InMemoryEventSequenceType.DEFAULT);
        }
        if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.ONLY_IMPORTED.get())) {
            directEvents = EventMethods.getImportedPersistentEventsDirect(_this, node);
            type = InMemoryEventSequenceType.ONLY_IMPORTED;
        } else if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get())) {
            Iterable<Entity> directHead = EventMethods.getImportedPersistentEventsDirect(_this, node);
            Iterable<Entity> directTail = EventMethods.getPersistentEventsDirect(_this, node);
            directEvents = QueryOperations.concat(directHead, directTail);
            type = InMemoryEventSequenceType.SEQUENTIAL_IMPORTED_REAL;
        } else if (EntityOperations.equals((Entity)sType, (Object)EventSequenceTypeImpl.LAYERED.get())) {
            directEvents = EventMethods.getSortedAbstractPersistentEvents(_this, node, true);
            type = InMemoryEventSequenceType.LAYERED;
        } else {
            directEvents = null;
            type = InMemoryEventSequenceType.ERROR;
        }
        return new Pair(directEvents, (Object)type);
    }

    public static void setImportType(Entity _this, Entity type) {
        DirectedAssociationSemantics.setToOne((Entity)_this, (String)"__EVENT_SEQUENCE_TYPE", (Entity)type);
    }

    public static void updateEventSequenceType(Entity _this, String eventPersistetClass) {
        Entity sequenceType = EventMethods.getEventSequenceType(_this);
        if (eventPersistetClass.equals("PersistentEvent")) {
            if (EntityOperations.equals((Entity)sequenceType, (Object)EventSequenceTypeImpl.ONLY_IMPORTED.get())) {
                EventMethods.setImportType(_this, EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get());
            }
        } else if (eventPersistetClass.equals("ImportedPersistentEvent")) {
            if (EntityOperations.equals((Entity)sequenceType, null)) {
                EventMethods.setImportType(_this, EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get());
            } else if (EntityOperations.equals((Entity)sequenceType, (Object)EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get())) {
                EventMethods.setImportType(_this, EventSequenceTypeImpl.LAYERED.get());
            }
        }
    }

    public static Entity getEventSequenceType(Entity _this) {
        return DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)_this, (String)"__EVENT_SEQUENCE_TYPE"), (String)"EventSequenceType");
    }
}

