/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import java.util.List;
import java.util.PriorityQueue;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.youtrack.event.refactoring.AbstracrtHistoryItem;
import jetbrains.youtrack.event.refactoring.HistoryItemQueuePart;

public abstract class AbstractHistoryItemQueueBuilder {
    protected String actionName;
    protected PriorityQueue<AbstracrtHistoryItem> queue;

    public AbstractHistoryItemQueueBuilder(String actionName) {
        this.actionName = actionName;
        this.queue = new PriorityQueue();
    }

    public PriorityQueue<AbstracrtHistoryItem> toQueue() {
        return this.queue;
    }

    public void populate() {
        this.populateWithPersistentEvents();
        this.populateWithIssues();
        this.populateWithComments();
        this.populateWithAttachments();
        this.populateWithWorkItems();
    }

    protected abstract void populateWithPersistentEvents();

    protected abstract void populateWithIssues();

    protected abstract void populateWithComments();

    protected abstract void populateWithAttachments();

    protected abstract void populateWithWorkItems();

    protected void populate(String msg, String name, final HistoryItemQueuePart queuePart) {
        final int total = queuePart.size();
        final Wrappers._int totalProcessed = new Wrappers._int(0);
        RefactoringUtil.doUnitTransactionalNew((String)msg, (int)total, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

            public Integer invoke(Integer packSize) {
                int processedInUnit = 0;
                int unitLimit = totalProcessed.value + packSize;
                for (int index = totalProcessed.value; index < unitLimit && index < total; ++index) {
                    queuePart.populateItem(index);
                    ++processedInUnit;
                }
                totalProcessed.value += processedInUnit;
                return processedInUnit;
            }
        }, (String)name, (int)1000);
    }

    protected <T extends Entity> void populate(String msg, String name, final List<T> entities, final _FunctionTypes._void_P1_E0<? super T> processEntity) {
        this.populate(msg, name, new HistoryItemQueuePart(){

            @Override
            public int size() {
                return entities.size();
            }

            @Override
            public void populateItem(int index) {
                processEntity.invoke(entities.get(index));
            }
        });
    }
}

