/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.DirectEntityEventAccumulationChecker;
import jetbrains.youtrack.event.refactoring.DirectLinkEventAccumulationChecker;
import jetbrains.youtrack.event.refactoring.DirectPropEventAccumulationChecker;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectIssueEventAccumulationChecker {
    protected static Log log = LogFactory.getLog(DirectIssueEventAccumulationChecker.class);
    private Entity currentIssue = null;
    private DirectEntityEventAccumulationChecker addedEntitiesChecker = new DirectEntityEventAccumulationChecker();
    private DirectEntityEventAccumulationChecker removedEntitiesChecker = new DirectEntityEventAccumulationChecker();
    private DirectLinkEventAccumulationChecker linksChecker = new DirectLinkEventAccumulationChecker();
    private DirectPropEventAccumulationChecker propsChecker = new DirectPropEventAccumulationChecker();

    public boolean breaksAccumulation(Entity ape) {
        boolean bad;
        block10: {
            Entity issue = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)ape, (String)"AbstractPersistentEvent")).getIssue(ape);
            if (!EntityOperations.equals((Entity)issue, (Object)this.currentIssue)) {
                this.currentIssue = issue;
                this.clear();
            }
            Entity type = AssociationSemantics.getToOne((Entity)ape, (String)"type");
            bad = false;
            try {
                if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_LINK.get())) {
                    bad = this.linksChecker.breaksAccumulation(ape);
                } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_PROPERTY.get())) {
                    bad = this.propsChecker.breaksAccumulation(ape);
                } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.ADD.get())) {
                    bad = this.addedEntitiesChecker.breaksAccumulation(ape);
                } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.REMOVE.get())) {
                    bad = this.removedEntitiesChecker.breaksAccumulation(ape);
                }
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block10;
                log.warn((Object)("Skip corrupted event " + DebugInfoMethods.toDebugString(ape) + ", " + t));
            }
        }
        return bad;
    }

    public void clear() {
        this.linksChecker.clear();
        this.propsChecker.clear();
        this.addedEntitiesChecker.clear();
        this.removedEntitiesChecker.clear();
    }
}

