/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.PriorityQueue;
import jetbrains.charisma.event.EventIssueListener;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.charisma.service.UserService;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.event.refactoring.AbstracrtHistoryItem;
import jetbrains.youtrack.event.refactoring.FixingHolesHistoryItemQueueBuilder;
import jetbrains.youtrack.event.refactoring.HistoryItemQueueBuilderDetectingDeleteRange;
import jetbrains.youtrack.event.refactoring.ImportedHistoryItemQueueBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventImportUtil {
    protected static Log log = LogFactory.getLog(EventImportUtil.class);

    public static void deleteAllPeristentEvents(final String actionName) {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                int total = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"));
                if (total > 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)(actionName + ": Started to delete old persistent events"));
                    }
                    String msgTemplate = "Deleted old persistent events %d. Speed %1.1f element/sec.";
                    RefactoringUtil.doUnit((String)msgTemplate, (int)total, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                        public Integer invoke(Integer packSize) {
                            int processed = 0;
                            for (Entity item : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"), (int)packSize))) {
                                EntityOperations.remove((Entity)item);
                                ++processed;
                            }
                            return processed;
                        }
                    }, (String)actionName);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)(actionName + ": No persistent events to remove"));
                }
            }
        });
    }

    public static void deletePeristentEvents(String actionName, Long fromId, Long tillId) {
        if (tillId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)(actionName + ": No persistent events to remove"));
            }
        } else {
            final long fromEventId = fromId == null ? 0L : fromId;
            final long tillEventId = Math.max(fromEventId, tillId);
            if (log.isInfoEnabled()) {
                log.info((Object)(actionName + ": Started to delete old persistent events in id range [" + fromEventId + ".." + tillEventId + "]"));
            }
            String msgTemplate = "Deleted old persistent events %d. Speed %1.1f element/sec.";
            RefactoringUtil.doUnitTransactionalNew((String)msgTemplate, (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                public Integer invoke(Integer packSize) {
                    int processed = 0;
                    TransientStoreSession storeTransaction = DnqUtils.getCurrentTransientSession();
                    EntityIterable events2 = storeTransaction.findIds("PersistentEvent", fromEventId, tillEventId);
                    for (Entity item : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)events2, (int)packSize))) {
                        EntityOperations.remove((Entity)item);
                        ++processed;
                    }
                    return processed;
                }
            }, (String)actionName, (int)10000);
        }
    }

    public static void recreateAllPersistentEvents(String actionName) {
        FixingHolesHistoryItemQueueBuilder qb = new FixingHolesHistoryItemQueueBuilder(actionName);
        qb.populate();
        EventImportUtil.recreatePersistentEvents(actionName, qb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recreatePersistentEvents(String actionName, final HistoryItemQueueBuilderDetectingDeleteRange qb) {
        final PriorityQueue<AbstracrtHistoryItem> queue = qb.toQueue();
        final EventIssueListener localEventIssueListner = (EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener");
        final Wrappers._T guest = new Wrappers._T();
        final Wrappers._T firstDeleteEventId = new Wrappers._T();
        final Wrappers._T lastDeleteEventId = new Wrappers._T();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                guest.value = ((UserService)ServiceLocator.getBean((String)"userService")).checkGuest();
                firstDeleteEventId.value = qb.getDeleteFrom();
                lastDeleteEventId.value = qb.getDeleteTill();
            }
        });
        ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
        localEventIssueListner.addIgnoreThread();
        try {
            RefactoringUtil.doUnitTransactionalNew((String)"Converted %d history items into events. Speed %1.1f element/sec", (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                public Integer invoke(Integer packSize) {
                    int processedInUnit;
                    for (processedInUnit = 0; !queue.isEmpty() && processedInUnit < packSize; ++processedInUnit) {
                        AbstracrtHistoryItem historyItem = (AbstracrtHistoryItem)queue.poll();
                        historyItem.convertToPersistentEvent(localEventIssueListner, (Entity)guest.value);
                    }
                    return processedInUnit;
                }
            }, (String)actionName, (int)10000);
            EventImportUtil.deletePeristentEvents(actionName, (Long)firstDeleteEventId.value, (Long)lastDeleteEventId.value);
        }
        finally {
            localEventIssueListner.removeIgnoreThread();
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
        }
    }

    public static Long getHistoryUpdated(Entity issue) {
        Object updated = PrimitiveAssociationSemantics.get((Entity)issue, (String)"historyUpdated", null);
        return (Long)(updated == null ? PrimitiveAssociationSemantics.get((Entity)issue, (String)"updated", null) : updated);
    }

    public static Entity getHistoryUpdatedBy(Entity issue) {
        return DnqUtils.cast((Object)AssociationSemantics.getToOne((Entity)issue, (String)"updatedBy"), (String)"User");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMissedImportedPersistentEvents(String actionName) {
        ImportedHistoryItemQueueBuilder qb = new ImportedHistoryItemQueueBuilder(actionName);
        qb.populate();
        final PriorityQueue<AbstracrtHistoryItem> queue = qb.toQueue();
        final EventIssueListener localEventIssueListner = (EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener");
        final Wrappers._T guest = new Wrappers._T();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                guest.value = ((UserService)ServiceLocator.getBean((String)"userService")).checkGuest();
            }
        });
        ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
        localEventIssueListner.addIgnoreThread();
        try {
            RefactoringUtil.doUnitTransactionalNew((String)"Converted %d history items into events. Speed %1.1f element/sec", (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                public Integer invoke(Integer packSize) {
                    int processedInUnit;
                    for (processedInUnit = 0; !queue.isEmpty() && processedInUnit < packSize; ++processedInUnit) {
                        AbstracrtHistoryItem historyItem = (AbstracrtHistoryItem)queue.poll();
                        historyItem.convertToPersistentEvent(localEventIssueListner, (Entity)guest.value);
                    }
                    return processedInUnit;
                }
            }, (String)actionName, (int)10000);
        }
        finally {
            localEventIssueListner.removeIgnoreThread();
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
        }
    }
}

