/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import java.util.List;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.event.refactoring.EventImportUtil;
import jetbrains.youtrack.event.refactoring.ReusableEventRefactoring;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventRecoveryInit
extends AppLifecycleListenerAdapter {
    private static final String DELETE_EVENTS_TO_KEY = "jetbrains.youtrack.deleteEventsTo";
    protected static Log log = LogFactory.getLog(EventRecoveryInit.class);
    private List<ReusableEventRefactoring> refactorings;
    private boolean myWasRecovered;

    public void setRefactorings(List<ReusableEventRefactoring> refactorings) {
        this.refactorings = ListSequence.fromList(refactorings).sort((_FunctionTypes._return_P1_E0)new ISelector<ReusableEventRefactoring, Comparable<?>>(){

            public Comparable<?> select(ReusableEventRefactoring it) {
                return it.getOrdinal();
            }
        }, true).toListSequence();
    }

    public void start() {
        this.setWasRecovered(this.deleteOldEvents());
        ListSequence.fromList(this.refactorings).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ReusableEventRefactoring>(){

            public void visit(ReusableEventRefactoring it) {
                EventRecoveryInit.this.setWasRecovered(it.applyReusable() || EventRecoveryInit.this.getWasRecovered());
            }
        });
    }

    private boolean deleteOldEvents() {
        block4: {
            String parameter = ConfigurationParameter.getParameter((String)DELETE_EVENTS_TO_KEY);
            if (parameter != null) {
                try {
                    Long toId = Long.parseLong(parameter);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Applying key jetbrains.youtrack.deleteEventsTo=" + toId));
                    }
                    EventImportUtil.deletePeristentEvents("Event deletion", null, toId);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Didn't apply key jetbrains.youtrack.deleteEventsTo=" + parameter + " due to wrong number format"));
                }
            }
        }
        return false;
    }

    public boolean getWasRecovered() {
        return this.myWasRecovered;
    }

    private void setWasRecovered(boolean value) {
        this.myWasRecovered = value;
    }
}

