/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.refactoring.DirectIssueEventAccumulationChecker;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import jetbrains.youtrack.event.rollback.IEventRollbackService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventRecoveryUtils {
    protected static Log log = LogFactory.getLog(EventRecoveryUtils.class);

    public static List<String> removeEventDuplicates(Entity issue) {
        ISetSequence identityMarks = SetSequence.fromSet(new HashSet());
        IListSequence deletedEvents = ListSequence.fromList((List)new LinkedList());
        for (Entity pEvent : Sequence.fromIterable((Iterable)QueryOperations.reverse(EventMethods.getPersistentEventsDirect(issue, null)))) {
            String mark = EventRecoveryUtils.getIdentityMark(pEvent);
            if (SetSequence.fromSet((Set)identityMarks).contains((Object)mark)) {
                ListSequence.fromList((List)deletedEvents).addElement((Object)(pEvent.toIdString() + ":" + mark));
                EntityOperations.remove((Entity)pEvent);
                continue;
            }
            SetSequence.fromSet((Set)identityMarks).addElement((Object)mark);
        }
        return deletedEvents;
    }

    public static List<String> removeUpdateHistory(Entity issue, boolean withLinks) {
        IListSequence deletedEvents = ListSequence.fromList((List)new LinkedList());
        for (Entity pEvent : Sequence.fromIterable(EventMethods.getAbstractPersistentEventsDirect(issue))) {
            Entity type = AssociationSemantics.getToOne((Entity)pEvent, (String)"type");
            if (!EntityOperations.equals((Entity)type, (Object)EventTypeImpl.ADD.get()) && !EntityOperations.equals((Entity)type, (Object)EventTypeImpl.REMOVE.get())) {
                if (!withLinks && ((String)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"memberName", String.class, null)).startsWith("$l")) continue;
                ListSequence.fromList((List)deletedEvents).addElement((Object)EventRecoveryUtils.deleteEvent(pEvent));
                continue;
            }
            Entity target = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)pEvent, (String)"AbstractPersistentEvent")).getTarget(pEvent);
            if (!DnqUtils._instanceOf((Object)target, (String)"IssueAttachment") || !((Boolean)PrimitiveAssociationSemantics.get((Entity)DnqUtils.cast((Object)target, (String)"IssueAttachment"), (String)"removed", Boolean.class, null)).booleanValue()) continue;
            ListSequence.fromList((List)deletedEvents).addElement((Object)EventRecoveryUtils.deleteEvent(pEvent));
        }
        return deletedEvents;
    }

    private static String deleteEvent(Entity pEvent) {
        String id = pEvent.toIdString();
        EntityOperations.remove((Entity)pEvent);
        return id;
    }

    private static String getIdentityMark(Entity pEvent) {
        String memberName = (String)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"memberName", String.class, null);
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)pEvent, (String)"AbstractPersistentEvent")).getTarget(pEvent).getId().toString() + ":" + (Long)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"timestamp", null) + (memberName == null ? "" : ":" + memberName);
    }

    public static int markCorruptedEventsBreakingHistoryConsistencyByDirectPass(Entity issue) {
        DirectIssueEventAccumulationChecker checker = new DirectIssueEventAccumulationChecker();
        int corrupted = 0;
        for (Entity ape : Sequence.fromIterable(EventMethods.getAbstractPersistentEventsDirect(issue))) {
            if (!checker.breaksAccumulation(ape)) continue;
            PrimitiveAssociationSemantics.set((Entity)ape, (String)"corrupted", (Comparable)Boolean.valueOf(true), Boolean.class);
            ++corrupted;
        }
        return corrupted;
    }

    public static int markCorruptedEventsBreakingHistoryConsistencyByBackwardPass(Entity issue) {
        int corrupted = 0;
        for (Entity ape : Sequence.fromIterable(((IEventRollbackService)ServiceLocator.getBean((String)"eventRollbackService")).findCorruptedPersistentEvents(issue))) {
            PrimitiveAssociationSemantics.set((Entity)ape, (String)"corrupted", (Comparable)Boolean.valueOf(true), Boolean.class);
            ++corrupted;
        }
        return corrupted;
    }

    public static int markCorruptedEventsBreakingTimestampOrder(Entity issue) {
        int corrupted = 0;
        long timestamp = 0L;
        for (Entity ape : Sequence.fromIterable(EventMethods.getAbstractPersistentEventsDirect(issue))) {
            long eventTimestamp = (Long)PrimitiveAssociationSemantics.get((Entity)ape, (String)"timestamp", null);
            if (eventTimestamp < timestamp) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Found event breaking timestamp order: " + DebugInfoMethods.toDebugString(ape)));
                }
                PrimitiveAssociationSemantics.set((Entity)ape, (String)"corrupted", (Comparable)Boolean.valueOf(true), Boolean.class);
                ++corrupted;
                continue;
            }
            if (eventTimestamp <= timestamp) continue;
            timestamp = eventTimestamp;
        }
        return corrupted;
    }

    public static int clearCorruptedEvents(Entity issue) {
        int unmarked = 0;
        for (Entity ape : Sequence.fromIterable((Iterable)QueryOperations.query(EventMethods.getAbstractPersistentEventsDirect(issue), (String)"AbstractPersistentEvent", (NodeBase)new PropertyEqual("corrupted", (Comparable)Boolean.TRUE)))) {
            PrimitiveAssociationSemantics.set((Entity)ape, (String)"corrupted", (Comparable)Boolean.valueOf(false), Boolean.class);
            ++unmarked;
        }
        return unmarked;
    }

    public static int removeCorruptedEvents(Entity issue) {
        int removed = 0;
        for (Entity ape : Sequence.fromIterable((Iterable)QueryOperations.query(EventMethods.getAbstractPersistentEventsDirect(issue), (String)"AbstractPersistentEvent", (NodeBase)new PropertyEqual("corrupted", (Comparable)Boolean.TRUE))).toListSequence()) {
            EntityOperations.remove((Entity)ape);
            ++removed;
        }
        return removed;
    }
}

