/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.AbstracrtHistoryItem;
import jetbrains.youtrack.event.refactoring.HistoryItem;
import jetbrains.youtrack.event.refactoring.MissedHistoryItemQueueBuilder;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class FixingHolesHistoryItemQueueBuilder
extends MissedHistoryItemQueueBuilder {
    protected static Log log = LogFactory.getLog(FixingHolesHistoryItemQueueBuilder.class);

    public FixingHolesHistoryItemQueueBuilder(String actionName) {
        super(actionName);
    }

    @Override
    @Nullable
    public Long getDeleteFrom() {
        return null;
    }

    @Override
    @Nullable
    public Long getDeleteTill() {
        Entity last = QueryOperations.getLast((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"));
        if (EntityOperations.equals((Entity)last, null)) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": Last old event for delete interval didn't found - events wasn't created yet"));
            }
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Found last old event for delete interval " + DebugInfoMethods.toDebugString(last)));
        }
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)last, (String)"AbstractPersistentEvent")).getId(last);
    }

    @Override
    protected void populateWithPersistentEvents() {
        List<Entity> events2;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add existed events to the history item queue"));
        }
        if ((events2 = this.getPersistentEvents()).isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No existed events"));
            }
        } else {
            String msg = "Processed %d events. Speed %1.1f element/sec. Estimated finish at %s.";
            this.populate(msg, this.actionName, events2, new _FunctionTypes._void_P1_E0<Entity>(){

                public void invoke(Entity pEvent) {
                    FixingHolesHistoryItemQueueBuilder.this.queue.add(FixingHolesHistoryItemQueueBuilder.this.createItem((Long)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"timestamp", null), pEvent, pEvent, AssociationSemantics.getToOne((Entity)pEvent, (String)"author")));
                }
            });
        }
    }

    @Override
    public AbstracrtHistoryItem createItem(Long t, Entity v0, Entity v1, Entity author) {
        return new HistoryItem(t, v0, v1, author);
    }
}

