/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.FixingHolesHistoryItemQueueBuilder;
import jetbrains.youtrack.event.refactoring.HistoryItem;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FixingHolesIncrementalHistoryItemQueueBuilder
extends FixingHolesHistoryItemQueueBuilder {
    protected static Log log = LogFactory.getLog(FixingHolesIncrementalHistoryItemQueueBuilder.class);
    private Long firstEventlessTime = Long.MAX_VALUE;
    private Long deleteFrom = null;
    private Long fixIssueCreatedFromTimestamp;

    public FixingHolesIncrementalHistoryItemQueueBuilder(String actionName, @Nullable Long timestamp) {
        super(actionName);
        this.fixIssueCreatedFromTimestamp = timestamp;
    }

    @Override
    public Long getDeleteFrom() {
        return this.deleteFrom;
    }

    @Override
    public void populate() {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"PersistentEvent", (NodeBase)new LinkEqual("type", EventTypeImpl.ADD.get())))) {
                    FixingHolesIncrementalHistoryItemQueueBuilder.this.bigSetOfEventedEntityIds.add(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getTarget(event2).getId());
                }
            }
        });
        this.findBeginAndPopulateWithIssues();
        if (this.hasNewEntitiesWithoutEvents) {
            String minTimeStr = DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)this.firstEventlessTime, (DateTimeZone)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), null);
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": First eventless issue created at " + this.firstEventlessTime + " (" + minTimeStr + ")"));
            }
        }
        this.populateWithComments();
        this.populateWithAttachments();
        this.populateWithWorkItems();
        this.populateWithPersistentEvents();
    }

    @Override
    protected List<Entity> getPersistentEvents() {
        final ArrayList<Entity> events2 = new ArrayList<Entity>(100000);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"PersistentEvent", (NodeBase)new PropertyRange("timestamp", PrimitiveAssociationSemantics.nextGreater((Comparable)FixingHolesIncrementalHistoryItemQueueBuilder.this.firstEventlessTime, Long.class), PrimitiveAssociationSemantics.positiveInfinity(Long.class))))) {
                    if (FixingHolesIncrementalHistoryItemQueueBuilder.this.deleteFrom == null) {
                        FixingHolesIncrementalHistoryItemQueueBuilder.this.deleteFrom = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getId(event2);
                        if (log.isInfoEnabled()) {
                            log.info((Object)(FixingHolesIncrementalHistoryItemQueueBuilder.this.actionName + ": Found first old event for delete interval " + DebugInfoMethods.toDebugString(event2)));
                        }
                    }
                    events2.add(event2);
                }
            }
        });
        return events2;
    }

    private void findBeginAndPopulateWithIssues() {
        List<Entity> issues;
        String what;
        String string = what = this.fixIssueCreatedFromTimestamp == null ? "all issues" : "issues starting from " + this.fixIssueCreatedFromTimestamp;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add " + what + " without events to the history item queue"));
        }
        List<Entity> list = issues = this.fixIssueCreatedFromTimestamp == null ? this.getIssues() : this.getIssuesFrom(this.fixIssueCreatedFromTimestamp);
        if (issues.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No non-draft issues without events detected"));
            }
        } else {
            this.hasNewEntitiesWithoutEvents = true;
            String msg = "Processed %d issues. Speed %1.1f element/sec. Estimated finish at %s.";
            this.populate(msg, this.actionName, issues, new _FunctionTypes._void_P1_E0<Entity>(){

                public void invoke(Entity issue) {
                    Long issueCreatedTime = (Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null);
                    if (issueCreatedTime == null) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " has undefined issue.created"));
                        }
                        return;
                    }
                    FixingHolesIncrementalHistoryItemQueueBuilder.this.firstEventlessTime = Math.min(FixingHolesIncrementalHistoryItemQueueBuilder.this.firstEventlessTime, issueCreatedTime);
                    FixingHolesIncrementalHistoryItemQueueBuilder.this.queue.add(new HistoryItem(issueCreatedTime, null, issue, AssociationSemantics.getToOne((Entity)issue, (String)"reporter")));
                }
            });
        }
    }

    private List<Entity> getIssuesFrom(final Long from) {
        final ArrayList<Entity> issues = new ArrayList<Entity>();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity nonDraftIssue : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new LinkEqual("draftOwner", null), (NodeBase)new PropertyRange("created", (Comparable)from, PrimitiveAssociationSemantics.positiveInfinity(Long.class)))))) {
                    if (!FixingHolesIncrementalHistoryItemQueueBuilder.this.withoutEvents(nonDraftIssue)) continue;
                    issues.add(nonDraftIssue);
                }
            }
        });
        return issues;
    }
}

