/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.timeTracking.TimeTrackingProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.AbstracrtHistoryItem;
import jetbrains.youtrack.event.refactoring.HistoryItemQueueBuilderDetectingDeleteRange;
import jetbrains.youtrack.event.refactoring.HistoryItemQueuePart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MissedHistoryItemQueueBuilder
extends HistoryItemQueueBuilderDetectingDeleteRange {
    protected static Log log = LogFactory.getLog(MissedHistoryItemQueueBuilder.class);
    protected Set<EntityId> bigSetOfEventedEntityIds = new HashSet<EntityId>();
    protected boolean hasNewEntitiesWithoutEvents = false;

    public MissedHistoryItemQueueBuilder(String actionName) {
        super(actionName);
    }

    @Override
    public boolean notNeccecaryToRecreate() {
        return !this.hasNewEntitiesWithoutEvents;
    }

    protected List<Entity> getPersistentEvents() {
        final Wrappers._int total = new Wrappers._int();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                total.value = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"));
            }
        });
        final ArrayList<Entity> events2 = new ArrayList<Entity>(total.value);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"))) {
                    if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)event2, (String)"type"), (Object)EventTypeImpl.ADD.get())) {
                        MissedHistoryItemQueueBuilder.this.bigSetOfEventedEntityIds.add(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getTarget(event2).getId());
                    }
                    events2.add(event2);
                }
            }
        });
        return events2;
    }

    protected List<Entity> getIssues() {
        final ArrayList<Entity> issues = new ArrayList<Entity>();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity nonDraftIssue : Sequence.fromIterable((Iterable)IssueImpl.getNonDrafts())) {
                    if (!MissedHistoryItemQueueBuilder.this.withoutEvents(nonDraftIssue)) continue;
                    issues.add(nonDraftIssue);
                }
            }
        });
        return issues;
    }

    @Override
    protected void populateWithIssues() {
        List<Entity> issues;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add issues without events to the history item queue"));
        }
        if ((issues = this.getIssues()).isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No non-draft issues without events detected"));
            }
        } else {
            this.hasNewEntitiesWithoutEvents = true;
            String msg = "Processed %d issues. Speed %1.1f element/sec. Estimated finish at %s.";
            this.populate(msg, this.actionName, issues, new _FunctionTypes._void_P1_E0<Entity>(){

                public void invoke(Entity issue) {
                    Long issueCreatedTime = (Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null);
                    if (issueCreatedTime == null) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " has undefined issue.created"));
                        }
                        return;
                    }
                    MissedHistoryItemQueueBuilder.this.queue.add(MissedHistoryItemQueueBuilder.this.createItem(issueCreatedTime, null, issue, AssociationSemantics.getToOne((Entity)issue, (String)"reporter")));
                }
            });
        }
    }

    @Override
    protected void populateWithComments() {
        HistoryItemQueuePart comments;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add comments without events to the history item queue"));
        }
        if ((comments = MissedHistoryItemQueueBuilder.getComments(this)).size() <= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No comments without events detected"));
            }
        } else {
            this.hasNewEntitiesWithoutEvents = true;
            String msg = "Processed %d comments. Speed %1.1f element/sec. Estimated finish at %s.";
            this.populate(msg, this.actionName, comments);
        }
    }

    @Override
    protected void populateWithAttachments() {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add attachments without events to the history item queue"));
        }
        String msg = "Processed %d attachments. Speed %1.1f element/sec. Estimated finish at %s.";
        HistoryItemQueuePart attachments = MissedHistoryItemQueueBuilder.getAttachments(this);
        if (attachments.size() <= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No attachments without events detected"));
            }
        } else {
            this.hasNewEntitiesWithoutEvents = true;
            this.populate(msg, this.actionName, attachments);
        }
    }

    @Override
    protected void populateWithWorkItems() {
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add work items without events to the history item queue"));
        }
        String msg = "Processed %d work items. Speed %1.1f element/sec. Estimated finish at %s.";
        HistoryItemQueuePart workItems = MissedHistoryItemQueueBuilder.getWorkItems(this);
        if (workItems.size() <= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No work items without events detected"));
            }
        } else {
            this.hasNewEntitiesWithoutEvents = true;
            this.populate(msg, this.actionName, workItems);
        }
    }

    public boolean withoutEvents(Entity entity) {
        return !this.bigSetOfEventedEntityIds.contains(entity.getId());
    }

    public boolean checkIssue(Entity issue, Entity entity) {
        boolean checked = true;
        if (EntityOperations.equals((Entity)issue, null)) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Missing " + entity.getType() + " " + entity.getId() + ", because it has no link to any issue"));
            }
            checked = false;
        } else if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isDraft(issue)) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Missing " + entity.getType() + " " + entity.getId() + ", because it is linked to the draft issue"));
            }
            checked = false;
        }
        return checked;
    }

    public void tryAddCreatedEnity(Long entityCreated, Entity entity, Entity author, Entity issue) {
        Long issueCreated = (Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null);
        if (issueCreated == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Missing " + entity.getType() + " " + entity.getId() + ", because it is linked to the issue with null creation time"));
            }
            return;
        }
        long timestamp = entityCreated == null || entityCreated <= issueCreated ? issueCreated + 1L : entityCreated;
        this.queue.add(this.createItem(timestamp, null, entity, author));
    }

    public abstract AbstracrtHistoryItem createItem(Long var1, Entity var2, Entity var3, Entity var4);

    private static HistoryItemQueuePart getAttachments(final MissedHistoryItemQueueBuilder builder) {
        final ArrayList attachments = new ArrayList();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity attachment : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"IssueAttachment"))) {
                    if (!builder.withoutEvents(attachment) || !builder.checkIssue(AssociationSemantics.getToOne((Entity)attachment, (String)"issue"), attachment)) continue;
                    attachments.add(attachment);
                }
            }
        });
        return new HistoryItemQueuePart(){

            @Override
            public int size() {
                return attachments.size();
            }

            @Override
            public void populateItem(int index) {
                Entity attachment = (Entity)attachments.get(index);
                builder.tryAddCreatedEnity((Long)PrimitiveAssociationSemantics.get((Entity)attachment, (String)"created", (Object)0), attachment, AssociationSemantics.getToOne((Entity)attachment, (String)"author"), AssociationSemantics.getToOne((Entity)attachment, (String)"issue"));
            }
        };
    }

    private static HistoryItemQueuePart getComments(final MissedHistoryItemQueueBuilder builder) {
        final ArrayList comments = new ArrayList();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity comment : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"IssueComment"))) {
                    if (((Boolean)PrimitiveAssociationSemantics.get((Entity)comment, (String)"deleted", Boolean.class, (Object)false)).booleanValue() || !builder.withoutEvents(comment) || !builder.checkIssue(AssociationSemantics.getToOne((Entity)comment, (String)"issue"), comment)) continue;
                    comments.add(comment);
                }
            }
        });
        return new HistoryItemQueuePart(){

            @Override
            public int size() {
                return comments.size();
            }

            @Override
            public void populateItem(int index) {
                Entity comment = (Entity)comments.get(index);
                builder.tryAddCreatedEnity((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null), comment, AssociationSemantics.getToOne((Entity)comment, (String)"author"), AssociationSemantics.getToOne((Entity)comment, (String)"issue"));
            }
        };
    }

    private static HistoryItemQueuePart getWorkItems(final MissedHistoryItemQueueBuilder builder) {
        final ArrayList workItems = new ArrayList();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity workItem : Sequence.fromIterable((Iterable)((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).getWorkItems())) {
                    TimeTrackingProvider.EventDto eventDto = ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).convert(workItem);
                    if (!builder.withoutEvents(workItem) || !builder.checkIssue(DnqUtils.cast((Object)eventDto.getIssue(), (String)"Issue"), workItem)) continue;
                    workItems.add(workItem);
                }
            }
        });
        return new HistoryItemQueuePart(){

            @Override
            public int size() {
                return workItems.size();
            }

            @Override
            public void populateItem(int index) {
                Entity workItem = (Entity)workItems.get(index);
                TimeTrackingProvider.EventDto eventDto = ((TimeTrackingProvider)ServiceLocator.getBean((String)"timeTrackingProvider")).convert(workItem);
                builder.tryAddCreatedEnity(eventDto.getCreated(), eventDto.getTarget(), DnqUtils.cast((Object)eventDto.getAuthor(), (String)"User"), DnqUtils.cast((Object)eventDto.getIssue(), (String)"Issue"));
            }
        };
    }
}

