/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.persistent.EventSequenceTypeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;

public class RefactoringLayeredToSequential
extends Refactoring {
    public static final String KEY = "jetbrains.charisma.event.RefactoringFixIncorrectlyLayeredEvents";
    protected static Log log = LogFactory.getLog(RefactoringLayeredToSequential.class);

    public boolean shouldApply(Entity a) {
        return "true".equals(ConfigurationParameter.getParameter((String)KEY));
    }

    public void apply(Entity a) {
        super.apply(a);
        Iterable issuesWithImportedPersistentEvents = QueryOperations.selectDistinct((Iterable)QueryOperations.queryGetAll((String)"ImportedPersistentEvent"), (String)AbstractPersistentEventImpl.getTargetAssociationName("Issue"));
        IListSequence issuesWithLayeredEvents = Sequence.fromIterable((Iterable)QueryOperations.intersect((Iterable)issuesWithImportedPersistentEvents, (Iterable)QueryOperations.query((String)"Issue", (NodeBase)new LinkEqual("__EVENT_SEQUENCE_TYPE", EventSequenceTypeImpl.LAYERED.get())))).toListSequence();
        if (log.isInfoEnabled()) {
            log.info((Object)("Found " + QueryOperations.getSize((Iterable)issuesWithLayeredEvents) + " issues with layered imported events"));
        }
        final Wrappers._int incorrectlyMarkedAsLayeredImported = new Wrappers._int(0);
        final Wrappers._int incorrectlyMarkedAsLayeredSequential = new Wrappers._int(0);
        final Entity sequential = EventSequenceTypeImpl.SEQUENTIAL_IMPORTED_REAL.get();
        RefactoringUtil.processListInBatches((String)"Checked %d issues with imported events", (List)issuesWithLayeredEvents, (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<Entity>(){

            public void invoke(Entity issue) {
                Entity firstRealEvent = QueryOperations.getFirst(EventMethods.getPersistentEventsDirect(issue, null));
                Entity lastImportedEvent = QueryOperations.getLast(EventMethods.getImportedPersistentEventsDirect(issue, null));
                boolean noRealEvents = EntityOperations.equals((Entity)firstRealEvent, null);
                if (noRealEvents || !EntityOperations.equals((Entity)lastImportedEvent, null) && DateTimeOperations.compare((Long)((Long)PrimitiveAssociationSemantics.get((Entity)firstRealEvent, (String)"timestamp", null)), (CompareType)CompareType.GT, (Long)((Long)PrimitiveAssociationSemantics.get((Entity)lastImportedEvent, (String)"timestamp", null)), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
                    if (noRealEvents) {
                        ++incorrectlyMarkedAsLayeredImported.value;
                    } else {
                        ++incorrectlyMarkedAsLayeredSequential.value;
                        EventMethods.setImportType(issue, sequential);
                    }
                }
            }
        }, (int)100);
        if (log.isInfoEnabled()) {
            log.info((Object)("Fixed " + incorrectlyMarkedAsLayeredSequential.value + " issues with events incorrectly marked as layered, " + incorrectlyMarkedAsLayeredImported.value + " imported-only remain"));
        }
    }
}

