/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.Set;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringRestoreIssueFieldUpdated
extends Refactoring {
    private static final String KEY = "jetbrains.youtrack.event.RefactoringRestoreIssueFieldUpdated";
    private static final String cLink = AbstractPersistentEventImpl.getTargetAssociationName("IssueComment");
    private static final String aLink = AbstractPersistentEventImpl.getTargetAssociationName("IssueAttachment");
    private static final String wLink = AbstractPersistentEventImpl.getTargetAssociationName("IssueWorkItem");
    private static Set<String> IGNORED_ISSUE_MEMBER_NAMES = SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{"voters", "votes", "tags"});
    protected static Log log = LogFactory.getLog(RefactoringRestoreIssueFieldUpdated.class);

    public boolean shouldApply(Entity a) {
        return "true".equals(ConfigurationParameter.getParameter((String)KEY));
    }

    public void apply(Entity a) {
        RefactoringUtil.processInBatches((String)"Verified timestamp \"updated\" in %d issue", (Iterable)IssueImpl.getNonDrafts(), (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<Entity>(){

            public void invoke(Entity issue) {
                RefactoringRestoreIssueFieldUpdated.this.restoreUpdatedFromHistory(DnqUtils.cast((Object)issue, (String)"Issue"));
            }
        }, (int)100);
    }

    private void restoreUpdatedFromHistory(Entity issue) {
        final Wrappers._boolean issueWithoutHistory = new Wrappers._boolean(true);
        long created = (Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"created", null);
        long updated = (Long)PrimitiveAssociationSemantics.get((Entity)issue, (String)"updated", null);
        Entity lastEventUpdatedIssue = QueryOperations.getFirst((Iterable)Sequence.fromIterable(EventMethods.getAbstractPersistentEventsReversed(issue, null)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                issueWithoutHistory.value = false;
                return RefactoringRestoreIssueFieldUpdated.this.affectsIssueFieldUpdated(it);
            }
        }));
        if (issueWithoutHistory.value) {
            if (created != updated && log.isWarnEnabled()) {
                log.warn((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " has no history, " + this.toWarnString(created, updated)));
            }
        } else if (EntityOperations.equals((Entity)lastEventUpdatedIssue, null)) {
            if (created != updated && log.isWarnEnabled()) {
                log.warn((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " has no events affecting property \"updated\", " + this.toWarnString(created, updated)));
            }
        } else {
            long timestamp = (Long)PrimitiveAssociationSemantics.get((Entity)lastEventUpdatedIssue, (String)"timestamp", null);
            if (timestamp != updated) {
                if (timestamp < updated && log.isDebugEnabled()) {
                    log.debug((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + " has last event affecting property \"updated\": " + DebugInfoMethods.toDebugString(lastEventUpdatedIssue) + ", but issue was updated later " + this.toWarnString(created, updated) + ", this information will be lost."));
                }
                PrimitiveAssociationSemantics.set((Entity)issue, (String)"updated", (Comparable)Long.valueOf(timestamp));
            }
        }
    }

    private String toWarnString(long created, long updated) {
        return "{created: " + created + ", updated: " + updated + "}";
    }

    private boolean affectsIssueFieldUpdated(Entity event2) {
        String memberName = (String)PrimitiveAssociationSemantics.get((Entity)event2, (String)"memberName", String.class, null);
        if (memberName == null) {
            return true;
        }
        ISetSequence links = SetSequence.fromSetWithValues(new HashSet(), (Iterable)event2.getLinkNames());
        return !SetSequence.fromSet((Set)links).contains((Object)cLink) && !SetSequence.fromSet((Set)links).contains((Object)aLink) && !SetSequence.fromSet((Set)links).contains((Object)wLink) && !SetSequence.fromSet(IGNORED_ISSUE_MEMBER_NAMES).contains((Object)memberName);
    }
}

