/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringRestoreMergedUserCommentEvents_JT_23991
extends Refactoring {
    private static final long CONFIDENCE_INTERVAL = 10000L;
    private static final String REFACTORING_TITLE = "RestoreMergedUserCommentEvents";
    private static final String REFACTORING_KEY = "jetbrains.charisma.event.RefactoringRestoreMergedUserCommentEvents_JT_23991";
    protected static Log log = LogFactory.getLog(RefactoringRestoreMergedUserCommentEvents_JT_23991.class);

    public void apply(final Entity a) {
        if (log.isInfoEnabled()) {
            log.info((Object)"RestoreMergedUserCommentEvents: started");
        }
        final LostEventRestorer restorer = new LostEventRestorer();
        IListSequence aliveComments = ListSequence.fromList(new ArrayList());
        final Wrappers._int corrected = new Wrappers._int(0);
        RefactoringUtil.doUnitTransactionalNew((String)"found %d comment creation events. Speed %1.1f events/sec.", (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>((List)aliveComments){
            final /* synthetic */ List val$aliveComments;
            {
                this.val$aliveComments = list;
            }

            public Integer invoke(Integer unitSize) {
                int correctedInUnit = 0;
                String toTargetCommentLink = AbstractPersistentEventImpl.getTargetAssociationName("IssueComment");
                And node = new And((NodeBase)new LinkEqual("type", EventTypeImpl.ADD.get()), (NodeBase)new LinkNotNull(toTargetCommentLink));
                TreeKeepingEntityIterable commentEvents = QueryOperations.query((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"), (String)"PersistentEvent", (NodeBase)node);
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.skip((Iterable)commentEvents, (int)corrected.value), (int)unitSize))) {
                    Entity comment = DnqUtils.cast((Object)((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getTarget(event2), (String)"IssueComment");
                    PrimitiveAssociationSemantics.set((Entity)comment, (String)"created", (Comparable)((Long)PrimitiveAssociationSemantics.get((Entity)event2, (String)"timestamp", null)));
                    if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)comment, (String)"deleted", Boolean.class, (Object)false)).booleanValue()) {
                        ListSequence.fromList((List)this.val$aliveComments).addElement((Object)comment);
                    }
                    ++correctedInUnit;
                }
                corrected.value += correctedInUnit;
                return correctedInUnit;
            }
        }, (String)REFACTORING_TITLE, (int)100000);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0((List)aliveComments, restorer){
            final /* synthetic */ List val$aliveComments;
            final /* synthetic */ LostEventRestorer val$restorer;
            {
                this.val$aliveComments = list;
                this.val$restorer = lostEventRestorer;
            }

            public void invoke() {
                TreeKeepingEntityIterable undefined = QueryOperations.query((Iterable)QueryOperations.exclude((Iterable)QueryOperations.query(null, (String)"IssueComment", (NodeBase)new And((NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE)), (NodeBase)new UnaryNot((NodeBase)new LinkEqual("issue", null)))), (Iterable)this.val$aliveComments), (String)"IssueComment", (NodeBase)new SortByProperty(null, "created", true));
                ISequence lost = Sequence.fromIterable((Iterable)undefined).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity it) {
                        return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"issue"), (String)"Issue")).isDraft(AssociationSemantics.getToOne((Entity)it, (String)"issue"));
                    }
                });
                this.val$restorer.locate((Iterable)lost);
                if (log.isInfoEnabled()) {
                    log.info((Object)("RestoreMergedUserCommentEvents: located " + this.val$restorer.located() + " lost comments"));
                }
            }
        });
        if (restorer.located() > 0) {
            _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    restorer.restore();
                }
            });
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"RestoreMergedUserCommentEvents: finished");
        }
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(RefactoringRestoreMergedUserCommentEvents_JT_23991.this.getName(), a);
            }
        });
    }

    public String getName() {
        return REFACTORING_KEY;
    }

    protected boolean requireTnx() {
        return false;
    }

    private class LostEventRestorer {
        private List<Tuples._3<Entity, Long, Long>> lostComments = ListSequence.fromList(new ArrayList());

        private LostEventRestorer() {
        }

        private void locate(Iterable<Entity> lost) {
            long prevEventTime = -1L;
            long prevEventId = -1L;
            long lastUsedVacancyId = -1L;
            Iterator eventIt = Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent")).iterator();
            Entity event2 = null;
            block0: for (Entity comment : Sequence.fromIterable(lost)) {
                long commentTime = (Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null);
                while (!EntityOperations.equals(event2, null) || eventIt.hasNext()) {
                    if (EntityOperations.equals(event2, null)) {
                        event2 = (Entity)eventIt.next();
                    }
                    long eventTime = (Long)PrimitiveAssociationSemantics.get((Entity)event2, (String)"timestamp", null);
                    long eventId = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getId(event2);
                    if (eventTime >= commentTime) {
                        long vacancyId;
                        long l = vacancyId = eventId - prevEventId > 1L ? Math.max(prevEventId + 1L, lastUsedVacancyId + 1L) : -1L;
                        if (vacancyId >= eventId) {
                            vacancyId = -1L;
                        }
                        if (vacancyId != -1L) {
                            long vacancyTime = commentTime > prevEventTime ? commentTime : prevEventTime;
                            this.save(comment, vacancyId, vacancyTime);
                            lastUsedVacancyId = vacancyId;
                            continue block0;
                        }
                        if (eventTime - commentTime >= 10000L) {
                            this.miss(comment);
                            continue block0;
                        }
                    }
                    prevEventTime = eventTime;
                    prevEventId = eventId;
                    event2 = null;
                }
            }
        }

        private void locateByUnits(final List<Entity> lost) {
            final Wrappers._long prevEventId = new Wrappers._long(-1L);
            final Wrappers._long prevEventTime = new Wrappers._long(-1L);
            final Wrappers._long lastUsedVacancyId = new Wrappers._long(-1L);
            final Wrappers._int processedEvent = new Wrappers._int(0);
            final Wrappers._int commentIndex = new Wrappers._int(0);
            final int commentSize = QueryOperations.getSize(lost);
            RefactoringUtil.doUnitTransactionalNew((String)"process %d events. Speed %1.1f events/sec.", (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                public Integer invoke(Integer unitSize) {
                    if (commentIndex.value >= commentSize) {
                        return 0;
                    }
                    int processedEventInUnit = 0;
                    for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.skip((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"), (int)processedEvent.value), (int)unitSize))) {
                        Entity comment;
                        long commentTime;
                        long eventId = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).getId(event2);
                        long eventTime = (Long)PrimitiveAssociationSemantics.get((Entity)event2, (String)"timestamp", null);
                        while (commentIndex.value < commentSize && eventTime >= (commentTime = ((Long)PrimitiveAssociationSemantics.get((Entity)(comment = (Entity)lost.get(commentIndex.value)), (String)"created", null)).longValue())) {
                            long vacancyId;
                            long l = vacancyId = eventId - prevEventId.value > 1L ? Math.max(prevEventId.value + 1L, lastUsedVacancyId.value + 1L) : -1L;
                            if (vacancyId < eventId && vacancyId != -1L) {
                                long vacancyTime = commentTime > prevEventTime.value ? commentTime : prevEventTime.value;
                                LostEventRestorer.this.save(comment, vacancyId, vacancyTime);
                                lastUsedVacancyId.value = vacancyId;
                                ++commentIndex.value;
                                continue;
                            }
                            if (eventTime - commentTime < 10000L) continue;
                            LostEventRestorer.this.miss(comment);
                            ++commentIndex.value;
                        }
                        prevEventId.value = eventId;
                        prevEventTime.value = eventTime;
                        ++processedEventInUnit;
                    }
                    processedEvent.value += processedEventInUnit;
                    return processedEventInUnit;
                }
            }, (String)RefactoringRestoreMergedUserCommentEvents_JT_23991.REFACTORING_TITLE, (int)100000);
        }

        private void miss(Entity comment) {
            String issue;
            String author = EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"author"), null) ? "null user" : (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"author"), (String)"login", String.class, (Object)"<no user>");
            String string = issue = EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"issue"), null) ? "null issue" : ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)comment, (String)"issue"), (String)"Issue")).getId(AssociationSemantics.getToOne((Entity)comment, (String)"issue"));
            if (log.isErrorEnabled()) {
                log.error((Object)("comment " + comment.toIdString() + " missed (" + author + "," + issue + ")"));
            }
        }

        private void save(Entity lostComment, long eventId, long eventTime) {
            if (log.isInfoEnabled()) {
                log.info((Object)("comment " + lostComment.toIdString() + " located to event " + eventId + " (d = " + (eventTime - (Long)PrimitiveAssociationSemantics.get((Entity)lostComment, (String)"created", null)) + " ms)"));
            }
            ListSequence.fromList(this.lostComments).addElement((Object)MultiTuple.from((Object)lostComment, (Object)eventId, (Object)eventTime));
        }

        private void restore() {
            final PersistentEntityStoreImpl pStore = (PersistentEntityStoreImpl)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore"));
            final int entityTypeId = pStore.getEntityTypeId("PersistentEvent", false);
            final Wrappers._int processed = new Wrappers._int(0);
            RefactoringUtil.doUnitTransactionalNew((String)"restored %d comment events. Speed %1.1f event/sec.", (int)ListSequence.fromList(this.lostComments).count(), (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

                public Integer invoke(Integer unitSize) {
                    int unitProcessed = 0;
                    for (Tuples._3 lost : ListSequence.fromList((List)LostEventRestorer.this.lostComments).skip(processed.value).take(unitSize.intValue())) {
                        Entity comment = (Entity)lost._0();
                        PersistentEntityId persistentId = new PersistentEntityId(entityTypeId, ((Long)lost._1()).longValue());
                        PersistentEntity pEntity = new PersistentEntity(pStore, persistentId);
                        ((PersistentStoreTransaction)DnqUtils.getCurrentPersistentSession()).saveEntity((Entity)pEntity);
                        Entity event2 = DnqUtils.cast((Object)DnqUtils.getCurrentTransientSession().newEntity((Entity)pEntity), (String)"PersistentEvent");
                        ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).setTarget(comment, event2);
                        ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)event2, (String)"AbstractPersistentEvent")).setIssue(AssociationSemantics.getToOne((Entity)comment, (String)"issue"), event2);
                        DirectedAssociationSemantics.setToOne((Entity)event2, (String)"author", (Entity)AssociationSemantics.getToOne((Entity)comment, (String)"author"));
                        PrimitiveAssociationSemantics.set((Entity)event2, (String)"timestamp", (Comparable)((Long)lost._2()));
                        DirectedAssociationSemantics.setToOne((Entity)event2, (String)"type", (Entity)EventTypeImpl.ADD.get());
                        PrimitiveAssociationSemantics.set((Entity)event2, (String)"memberName", null, String.class);
                        ++unitProcessed;
                    }
                    processed.value += unitProcessed;
                    return unitProcessed;
                }
            }, (String)RefactoringRestoreMergedUserCommentEvents_JT_23991.REFACTORING_TITLE, (int)100);
        }

        private int located() {
            return ListSequence.fromList(this.lostComments).count();
        }
    }
}

