/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringSplitModifyEventType
extends Refactoring {
    private static final String REFERENCE_LOG_TITLE = "Split MODIFY type";
    private static final int PACK_SIZE = 100000;
    private static final String REFACTORING_KEY = "jetbrains.charisma.event.RefactoringSplitModifyEventType";
    protected static Log log = LogFactory.getLog(RefactoringSplitModifyEventType.class);

    public void apply(final Entity a) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Split MODIFY type: started");
        }
        String msg = "processed %d events. Speed %1.1f events/sec";
        final Wrappers._int totalProcessed = new Wrappers._int(0);
        RefactoringUtil.doUnitTransactionalNew((String)msg, (int)-1, (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

            public Integer invoke(Integer packSize) {
                int unitProcessed = 0;
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.skip((Iterable)QueryOperations.query(null, (String)"PersistentEvent", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("memberName", (Comparable)null))), (int)totalProcessed.value), (int)packSize))) {
                    if (RefactoringSplitModifyEventType.this.isLinkEvent(event2)) {
                        DirectedAssociationSemantics.setToOne((Entity)event2, (String)"type", (Entity)EventTypeImpl.MODIFY_LINK.get());
                    } else {
                        DirectedAssociationSemantics.setToOne((Entity)event2, (String)"type", (Entity)EventTypeImpl.MODIFY_PROPERTY.get());
                    }
                    ++unitProcessed;
                }
                totalProcessed.value += unitProcessed;
                return unitProcessed;
            }
        }, (String)REFERENCE_LOG_TITLE, (int)100000);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(RefactoringSplitModifyEventType.this.getName(), a);
            }
        });
    }

    public String getName() {
        return REFACTORING_KEY;
    }

    protected boolean requireTnx() {
        return false;
    }

    private boolean isLinkEvent(Entity event2) {
        for (String linkName : event2.getLinkNames()) {
            if (!AbstractPersistentEventImpl.isAddedOrRemovedLinkName(linkName)) continue;
            return true;
        }
        return false;
    }
}

