/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Refactoring_JT_23421
extends Refactoring {
    private static final String COMMENT_TEXT_MEMBER_NAME = "text";
    private static final String REFACTORING_KEY = "jetbrains.charisma.event.Refactoring_JT_23421";
    protected static Log log = LogFactory.getLog(Refactoring_JT_23421.class);

    public void apply(Entity a) {
        Long minLastUpdatedDate = DateTimeOperations.convert((Date)new Date(114, 0, 1));
        ISetSequence processedComments = SetSequence.fromSet(new HashSet());
        Wrappers._int corruptedComments = new Wrappers._int(0);
        IListSequence suspectedEvents = Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"PersistentEvent", (NodeBase)new And((NodeBase)new PropertyRange("timestamp", PrimitiveAssociationSemantics.nextGreater((Comparable)minLastUpdatedDate, Long.class), PrimitiveAssociationSemantics.positiveInfinity(Long.class)), (NodeBase)new PropertyEqual("memberName", (Comparable)((Object)COMMENT_TEXT_MEMBER_NAME))))).toListSequence();
        Wrappers._int processedEvents = new Wrappers._int(0);
        this.doUnit("processed %d comment text persistent events", QueryOperations.getSize((Iterable)suspectedEvents), (_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Integer, Integer>((List)suspectedEvents, processedEvents, (Set)processedComments, corruptedComments){
            final /* synthetic */ List val$suspectedEvents;
            final /* synthetic */ Wrappers._int val$processedEvents;
            final /* synthetic */ Set val$processedComments;
            final /* synthetic */ Wrappers._int val$corruptedComments;
            {
                this.val$suspectedEvents = list;
                this.val$processedEvents = _int2;
                this.val$processedComments = set;
                this.val$corruptedComments = _int3;
            }

            public Integer invoke(Integer count) {
                int processedInUnit = 0;
                for (Entity suspectedEvent : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.skip((Iterable)this.val$suspectedEvents, (int)this.val$processedEvents.value), (int)count))) {
                    Entity target;
                    ++processedInUnit;
                    if (EntityOperations.isRemoved((Entity)suspectedEvent) || !DnqUtils._instanceOf((Object)(target = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)suspectedEvent, (String)"AbstractPersistentEvent")).getTarget(suspectedEvent)), (String)"IssueComment") || QueryOperations.contains((Iterable)this.val$processedComments, (Entity)target)) continue;
                    Object currentValue = PrimitiveAssociationSemantics.getBlobAsString((Entity)DnqUtils.cast((Object)target, (String)"IssueComment"), (String)Refactoring_JT_23421.COMMENT_TEXT_MEMBER_NAME);
                    boolean corrupted = false;
                    for (Entity textEvent : Sequence.fromIterable((Iterable)QueryOperations.reverse((Iterable)QueryOperations.query(EventMethods.getPersistentEventsDirect(target, null), (String)"PersistentEvent", (NodeBase)new PropertyEqual("memberName", (Comparable)((Object)Refactoring_JT_23421.COMMENT_TEXT_MEMBER_NAME)))))) {
                        try {
                            currentValue = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)textEvent, (String)"AbstractPersistentEvent")).getOldPropertyValue((Comparable)currentValue, textEvent);
                        }
                        catch (RuntimeException ex) {
                            corrupted = true;
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Persistent event " + DebugInfoMethods.toDebugString(textEvent) + " successfully removed"));
                            }
                            EntityOperations.remove((Entity)textEvent);
                        }
                    }
                    if (corrupted) {
                        ++this.val$corruptedComments.value;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Fixed corrupted comment " + target.toIdString() + " in issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)DnqUtils.cast((Object)target, (String)"IssueComment"), (String)"issue"), (String)"Issue")).getId(AssociationSemantics.getToOne((Entity)DnqUtils.cast((Object)target, (String)"IssueComment"), (String)"issue"))));
                        }
                    }
                    SetSequence.fromSet((Set)this.val$processedComments).addElement((Object)target);
                }
                this.val$processedEvents.value += processedInUnit;
                return processedInUnit;
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("Total: fixed " + corruptedComments.value + " corrupted comments"));
        }
        ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(this.getName(), a);
    }

    public String getName() {
        return REFACTORING_KEY;
    }
}

