/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.HistoryItem;
import jetbrains.youtrack.event.refactoring.HistoryItemQueueBuilderDetectingDeleteRange;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class RestoreEventsHistoryItemQueueBuilder
extends HistoryItemQueueBuilderDetectingDeleteRange {
    protected static Log log = LogFactory.getLog(RestoreEventsHistoryItemQueueBuilder.class);

    public RestoreEventsHistoryItemQueueBuilder(String actionName) {
        super(actionName);
    }

    @Override
    @Nullable
    public Long getDeleteFrom() {
        return null;
    }

    @Override
    @Nullable
    public Long getDeleteTill() {
        Entity last = QueryOperations.getLast((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"));
        if (EntityOperations.equals((Entity)last, null)) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": Last old event for delete interval didn't found - events wasn't created yet"));
            }
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Found last old event for delete interval " + DebugInfoMethods.toDebugString(last)));
        }
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)last, (String)"AbstractPersistentEvent")).getId(last);
    }

    private List<Entity> getPersistentEvents() {
        final Wrappers._int total = new Wrappers._int();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                total.value = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"));
            }
        });
        final ArrayList<Entity> events2 = new ArrayList<Entity>(total.value);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                for (Entity event2 : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"PersistentEvent"))) {
                    events2.add(event2);
                }
            }
        });
        return events2;
    }

    private String getIdentityMark(Entity pEvent) {
        String memberName = (String)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"memberName", String.class, null);
        return ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)pEvent, (String)"AbstractPersistentEvent")).getTarget(pEvent).getId().toString() + (Long)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"timestamp", null) + (memberName == null ? "" : memberName);
    }

    @Override
    protected void populateWithPersistentEvents() {
        List<Entity> events2;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.actionName + ": Started to add existed events to the history item queue skiping duplicates"));
        }
        if ((events2 = this.getPersistentEvents()).isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.actionName + ": No existed events"));
            }
        } else {
            ISetSequence identityMarks = SetSequence.fromSet(new HashSet());
            String msg = "Processed %d events. Speed %1.1f element/sec. Estimated finish at %s.";
            this.populate(msg, this.actionName, events2, new _FunctionTypes._void_P1_E0<Entity>((Set)identityMarks){
                final /* synthetic */ Set val$identityMarks;
                {
                    this.val$identityMarks = set;
                }

                public void invoke(Entity pEvent) {
                    block3: {
                        try {
                            String mark = RestoreEventsHistoryItemQueueBuilder.this.getIdentityMark(pEvent);
                            if (!SetSequence.fromSet((Set)this.val$identityMarks).contains((Object)mark)) {
                                RestoreEventsHistoryItemQueueBuilder.this.queue.add(new HistoryItem((Long)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"timestamp", null), pEvent, pEvent, AssociationSemantics.getToOne((Entity)pEvent, (String)"author")));
                                SetSequence.fromSet((Set)this.val$identityMarks).addElement((Object)mark);
                            }
                        }
                        catch (IllegalStateException ise) {
                            if (!log.isWarnEnabled()) break block3;
                            log.warn((Object)("Skip event " + DebugInfoMethods.toDebugString(pEvent) + ", " + ise.getMessage()));
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void populateWithIssues() {
    }

    @Override
    protected void populateWithComments() {
    }

    @Override
    protected void populateWithAttachments() {
    }

    @Override
    protected void populateWithWorkItems() {
    }

    @Override
    public boolean notNeccecaryToRecreate() {
        return false;
    }
}

