/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import jetbrains.charisma.event.EventIssueListener;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.RuleEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReusableEventRefactoring
extends Refactoring {
    protected static Log log = LogFactory.getLog(ReusableEventRefactoring.class);
    private String optionKey;
    private int ordinal;

    public String getOptionKey() {
        return this.optionKey;
    }

    public void setOptionKey(String optionKey) {
        this.optionKey = optionKey;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void apply(Entity a) {
        this.execute();
        ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(this.getName(), a);
    }

    public boolean shouldApplyReusable() {
        return "true".equals(ConfigurationParameter.getParameter((String)this.optionKey));
    }

    public boolean applyReusable() {
        if (this.shouldApplyReusable()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Applying key " + this.optionKey));
            }
            return this.execute();
        }
        return false;
    }

    private boolean execute() {
        boolean result;
        ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
        ((EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).addIgnoreThread();
        try {
            result = this.doApply();
        }
        catch (Throwable t) {
            result = false;
            if (log.isWarnEnabled()) {
                log.warn((Object)(this.getName() + " refactoring failed due to " + t.getMessage()));
            }
        }
        finally {
            ((EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).removeIgnoreThread();
            ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
        }
        return result;
    }

    protected abstract boolean doApply();
}

