/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.refactoring.ReusableEventRefactoring;
import jetbrains.youtrack.event.rollback.IEventRollbackService;

public class ReusableRefactoringHardRestoreHistoryConsistency
extends ReusableEventRefactoring {
    @Override
    protected boolean doApply() {
        try {
            this.batchRemove();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void batchRemove() {
        final List<EntityId> idsToRemove = this.findEventIdsToRemove();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                final TransientStoreSession session = ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession();
                RefactoringUtil.processListInBatches((String)"Hard history consistency restoring: removed %d events", (List)idsToRemove, (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<EntityId>(){

                    public void invoke(EntityId id) {
                        EntityOperations.remove((Entity)session.getEntity(id));
                    }
                }, (int)1000);
            }
        });
    }

    private List<EntityId> findEventIdsToRemove() {
        final ArrayList<EntityId> idsToRemove = new ArrayList<EntityId>();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                RefactoringUtil.processInBatches((String)"Hard history consistency restoring: processed %d issues", (Iterable)IssueImpl.getNonDrafts(), (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<Entity>(){

                    public void invoke(Entity issue) {
                        for (Entity event2 : Sequence.fromIterable(((IEventRollbackService)ServiceLocator.getBean((String)"eventRollbackService")).findCorruptedPersistentEvents(DnqUtils.cast((Object)issue, (String)"Issue")))) {
                            idsToRemove.add(event2.getId());
                        }
                    }
                }, (int)1000);
            }
        });
        return idsToRemove;
    }
}

