/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.refactoring.AbstractHistoryItemQueueBuilder;
import jetbrains.youtrack.event.refactoring.EventImportUtil;
import jetbrains.youtrack.event.refactoring.FixingHolesIncrementalHistoryItemQueueBuilder;
import jetbrains.youtrack.event.refactoring.HistoryItemQueueBuilderDetectingDeleteRange;
import jetbrains.youtrack.event.refactoring.ReusableEventRefactoring;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReusableRefactoringRecreateMissingAddEventsAndRestoreOrder
extends ReusableEventRefactoring {
    private static final String RECREATE_EVENTS_FROM_KEY = "jetbrains.youtrack.recreateEventsFrom";
    protected static Log log = LogFactory.getLog(ReusableRefactoringRecreateMissingAddEventsAndRestoreOrder.class);

    @Override
    protected boolean doApply() {
        if (!QueryOperations.isEmpty((Iterable)QueryOperations.query(null, (String)"ImportedPersistentEvent", (NodeBase)new LinkEqual("type", EventTypeImpl.ADD.get())))) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Persistent events recreation is canceled due to presence of ImportedPersistentEvents with type ADD");
            }
            return false;
        }
        String actionName = "Recreate events restoring missed";
        String timeParameter = ConfigurationParameter.getParameter((String)RECREATE_EVENTS_FROM_KEY);
        Long timestamp = null;
        if (timeParameter != null) {
            try {
                timestamp = Long.parseLong(timeParameter);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Applying key jetbrains.youtrack.recreateEventsFrom=" + timestamp));
                }
            }
            catch (NumberFormatException nfe) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Didn't apply key jetbrains.youtrack.recreateEventsFrom=" + timeParameter + " due to wrong number format"));
                }
                return false;
            }
        }
        FixingHolesIncrementalHistoryItemQueueBuilder qb = new FixingHolesIncrementalHistoryItemQueueBuilder("Recreate events restoring missed", timestamp);
        ((AbstractHistoryItemQueueBuilder)qb).populate();
        if (((HistoryItemQueueBuilderDetectingDeleteRange)qb).notNeccecaryToRecreate()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Recreate events restoring missed: No new entities without events, recreation is canceled");
            }
            return false;
        }
        EventImportUtil.recreatePersistentEvents("Recreate events restoring missed", qb);
        return true;
    }
}

