/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.event.ChangeHandler;
import jetbrains.charisma.event.EventIssueListener;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.refactoring.ReusableEventRefactoring;
import org.jetbrains.annotations.NotNull;

public class ReusableRefactoringRemoveEmptyTargetEvents
extends ReusableEventRefactoring {
    @Override
    protected boolean doApply() {
        try {
            this.batchRemove("ImportedPersistentEvent");
            this.batchRemove("PersistentEvent");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void batchRemove(final String entityType) {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                Iterable eventsToRemove = ReusableRefactoringRemoveEmptyTargetEvents.this.find(entityType);
                RefactoringUtil.processInBatchesReducingSequence((String)("Empty target events clearance: removed %d " + entityType + "s with empty target"), (Iterable)eventsToRemove, (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<Entity>(){

                    public void invoke(Entity entity) {
                        EntityOperations.remove((Entity)entity);
                    }
                }, (int)1000);
            }
        });
    }

    private Iterable<Entity> find(String entityType) {
        final Wrappers._T withoutTargetNode = new Wrappers._T(null);
        Sequence.fromIterable((Iterable)((EventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).getChangeHandlers()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<ChangeHandler>(){

            public void visit(ChangeHandler it) {
                String targetLinkName = AbstractPersistentEventImpl.getTargetAssociationName(it.getTypeName());
                withoutTargetNode.value = withoutTargetNode.value == null ? new LinkEqual(targetLinkName, null) : new And((NodeBase)withoutTargetNode.value, (NodeBase)new LinkEqual(targetLinkName, null));
            }
        });
        return QueryOperations.query(this.getAllEvents(entityType), (String)entityType, (NodeBase)((NodeBase)withoutTargetNode.value));
    }

    private Iterable<Entity> getAllEvents(@NotNull String entityType) {
        return entityType.equals("ImportedPersistentEvent") ? QueryOperations.queryGetAll((String)"ImportedPersistentEvent") : QueryOperations.queryGetAll((String)"PersistentEvent");
    }
}

