/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.ComparableGetterSort;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.EventMethods;
import jetbrains.youtrack.event.persistent.EventSequenceTypeImpl;
import jetbrains.youtrack.event.refactoring.DirectIssueEventAccumulationChecker;
import jetbrains.youtrack.event.refactoring.ReusableEventRefactoring;

public class ReusableRefactoringSoftRestoreHistoryConsistency
extends ReusableEventRefactoring {
    private static String ISSUE_LINK_NAME = AbstractPersistentEventImpl.getTargetAssociationName("Issue");

    @Override
    protected boolean doApply() {
        try {
            this.batchRemove("ImportedPersistentEvent");
            this.batchRemove("PersistentEvent");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void batchRemove(final String eventPerisistentType) {
        final List<EntityId> idsToRemove = this.findEventIdsToRemove(eventPerisistentType);
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                final TransientStoreSession session = ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession();
                RefactoringUtil.processListInBatches((String)("Soft history consistency restoring: removed %d" + eventPerisistentType + "s"), (List)idsToRemove, (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<EntityId>(){

                    public void invoke(EntityId id) {
                        EntityOperations.remove((Entity)session.getEntity(id));
                    }
                }, (int)1000);
            }
        });
    }

    private List<Entity> getSortedEvents(String eventPerisistentType) {
        return ListSequence.fromIterable((Iterable)QueryOperations.query(null, (String)eventPerisistentType, (NodeBase)ComparableGetterSort.create(null, (ComparableGetter)new ComparableGetter(){

            public Entity select(Entity event2) {
                return AssociationSemantics.getToOne((Entity)event2, (String)ISSUE_LINK_NAME);
            }
        }, (boolean)true))).toList();
    }

    private List<EntityId> findEventIdsToRemove(final String eventPerisistentType) {
        final DirectIssueEventAccumulationChecker checker = new DirectIssueEventAccumulationChecker();
        final ArrayList<EntityId> idsToRemove = new ArrayList<EntityId>();
        final Wrappers._T events2 = new Wrappers._T();
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                events2.value = ReusableRefactoringSoftRestoreHistoryConsistency.this.getSortedEvents(eventPerisistentType);
            }
        });
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                boolean imported = eventPerisistentType.equals("ImportedPersistentEvent");
                final Entity sequenceType = imported ? EventSequenceTypeImpl.ONLY_IMPORTED.get() : null;
                RefactoringUtil.processListInBatches((String)("Soft history consistency restoring: processed %d " + eventPerisistentType + "s"), (List)((List)events2.value), (_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<Entity>(){

                    public void invoke(Entity entity) {
                        Entity ape = DnqUtils.cast((Object)entity, (String)"AbstractPersistentEvent");
                        if (EntityOperations.equals((Entity)EventMethods.getEventSequenceType(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)ape, (String)"AbstractPersistentEvent")).getIssue(ape)), (Object)sequenceType) && checker.breaksAccumulation(ape)) {
                            idsToRemove.add(entity.getId());
                        }
                    }
                }, (int)1000);
            }
        });
        return idsToRemove;
    }
}

