/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.InputStream;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.youtrack.event.rollback.SingleEvent;

public class BlobPropertyEvent
extends SingleEvent {
    private InputStream newPropertyValue;
    private String newPropertyValueString;
    private InputStream oldPropertyValue;
    private String oldPropertyValueString;
    private String memberName;
    private Entity type;

    public BlobPropertyEvent(Entity event2, String memberName, InputStream oldPropertyValue, InputStream newPropertyValue, Entity type) {
        super(event2);
        this.memberName = memberName;
        this.oldPropertyValue = oldPropertyValue;
        this.newPropertyValue = newPropertyValue;
        this.type = type;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public Comparable getOldPropertyValue() {
        String result;
        if (this.oldPropertyValueString != null) {
            return this.oldPropertyValueString;
        }
        this.oldPropertyValueString = result = SingleEvent.blobToString(this.oldPropertyValue);
        return result;
    }

    @Override
    public Comparable getNewPropertyValue() {
        String result;
        if (this.newPropertyValueString != null) {
            return this.newPropertyValueString;
        }
        this.newPropertyValueString = result = SingleEvent.blobToString(this.newPropertyValue);
        return result;
    }

    @Override
    public Iterable<Entity> getRemovedLinks() {
        return EntityIterableBase.EMPTY;
    }

    @Override
    public Iterable<Entity> getAddedLinks() {
        return EntityIterableBase.EMPTY;
    }

    @Override
    public boolean isPropertyChange() {
        return true;
    }

    @Override
    public Entity getType() {
        return EntityOperations.equals((Entity)this.type, null) ? AssociationSemantics.getToOne((Entity)this.pEvent, (String)"type") : this.type;
    }

    @Override
    public boolean isVisible() {
        return true;
    }
}

