/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventTypeImpl;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.rollback.SingleEvent;

public class DebugInfoMethods {
    private static String toDebugInfo(Event _this, boolean secure) {
        String taTy;
        String taId;
        String auId;
        String nullStub = "null";
        Entity ape = DnqUtils.cast((Object)_this.getPrimaryEntity(), (String)"AbstractPersistentEvent");
        String evPt = EntityOperations.equals((Entity)ape, null) ? nullStub : ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)ape, (String)"AbstractPersistentEvent")).getTypePrefix(ape);
        String evId = EntityOperations.equals((Entity)ape, null) ? nullStub : _this.getPrimaryEntity().toIdString();
        Entity etype = _this.getType();
        String tyId = EntityOperations.equals((Entity)etype, null) ? nullStub : (EntityOperations.equals((Entity)etype, (Object)EventTypeImpl.MODIFY_LINK.get()) ? "LINK" : (EntityOperations.equals((Entity)etype, (Object)EventTypeImpl.MODIFY_PROPERTY.get()) ? "PROP" : (EntityOperations.equals((Entity)etype, (Object)EventTypeImpl.MODIFY_STUB.get()) ? "STUB" : (EntityOperations.equals((Entity)etype, (Object)EventTypeImpl.ADD.get()) ? "ADD_" : "REM_"))));
        long time = _this.getTimestamp();
        String member = _this.getMemberName();
        String meId = member == null ? nullStub : member;
        Entity author = _this.getAuthor();
        String string = auId = EntityOperations.equals((Entity)author, null) ? nullStub : author.toIdString();
        String auNm = EntityOperations.equals((Entity)author, null) ? nullStub : (secure ? auId : (String)PrimitiveAssociationSemantics.get((Entity)author, (String)"fullName", String.class, null));
        try {
            Entity target = _this.getTarget();
            taId = target.toIdString();
            taTy = target.getType();
        }
        catch (IllegalStateException ise) {
            taId = nullStub;
            taTy = nullStub;
        }
        Entity issue = _this.getIssue();
        String isId = EntityOperations.equals((Entity)issue, null) ? nullStub : ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue);
        Byte marker = _this.getMarker();
        String delim = ":";
        StringBuilder sb = new StringBuilder();
        sb.append(evPt).append(delim);
        sb.append(evId).append(delim);
        sb.append(tyId).append(delim);
        sb.append(auId).append(delim);
        sb.append(time).append(delim);
        sb.append(isId).append(delim);
        sb.append(taId).append(delim);
        sb.append(taTy).append(delim);
        sb.append(meId).append(" [");
        sb.append(auNm).append("]");
        if (marker != null) {
            sb.append(delim).append(marker);
        }
        if (!EntityOperations.equals((Entity)ape, null) && ((Boolean)PrimitiveAssociationSemantics.get((Entity)ape, (String)"corrupted", Boolean.class, null)).booleanValue()) {
            sb.append("*");
        }
        return sb.toString();
    }

    public static String toDebugString(Event _this) {
        return DebugInfoMethods.toDebugInfo(_this, false);
    }

    public static String toSecureDebugString(Event _this) {
        return DebugInfoMethods.toDebugInfo(_this, true);
    }

    public static String toDebugString(Entity _this) {
        return DebugInfoMethods.toDebugString(new SingleEvent(_this));
    }

    public static Iterable<String> getDeltaDescriptions(Entity _this) {
        IListSequence delta = ListSequence.fromList(new ArrayList(2));
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.MODIFY_PROPERTY.get())) {
            Comparable old = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getOldPropertyDirectly(_this);
            ListSequence.fromList((List)delta).addElement((Object)("PROP-: " + old));
            ListSequence.fromList((List)delta).addElement((Object)("PROP\u00b1: " + ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).isDeltaEncoded(_this)));
        } else if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.MODIFY_LINK.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("LINK-: " + IterableUtils.join((Iterable)Sequence.fromIterable(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getRemovedLinks(_this)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return DebugInfoMethods.toEntityDebugInfo(it);
                }
            }), (String)"; ")));
            ListSequence.fromList((List)delta).addElement((Object)("LINK+: " + IterableUtils.join((Iterable)Sequence.fromIterable(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getAddedLinks(_this)).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return DebugInfoMethods.toEntityDebugInfo(it);
                }
            }), (String)"; ")));
        } else if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.ADD.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("ENTITY+: " + DebugInfoMethods.toEntityDebugInfo(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getTarget(_this))));
        } else if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.REMOVE.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("ENTITY-: " + DebugInfoMethods.toEntityDebugInfo(((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)_this, (String)"AbstractPersistentEvent")).getTarget(_this))));
        } else if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)_this, (String)"type"), (Object)EventTypeImpl.MODIFY_STUB.get())) {
            ListSequence.fromList((List)delta).addElement((Object)"STUB");
        } else {
            ListSequence.fromList((List)delta).addElement((Object)"Obsolete event type");
        }
        return delta;
    }

    public static Iterable<String> getDeltaDescriptions(Event _this) {
        IListSequence delta = ListSequence.fromList(new ArrayList(2));
        Entity type = _this.getType();
        if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_PROPERTY.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("PROP-: " + _this.getOldPropertyValue()));
            ListSequence.fromList((List)delta).addElement((Object)("PROP+: " + _this.getNewPropertyValue()));
            Entity parent2 = DnqUtils.cast((Object)_this.getPrimaryEntity(), (String)"AbstractPersistentEvent");
            if (!EntityOperations.equals((Entity)parent2, null)) {
                ListSequence.fromList((List)delta).addElement((Object)("DELTA: " + ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)parent2, (String)"AbstractPersistentEvent")).isDeltaEncoded(parent2)));
            }
        } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_LINK.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("LINK-: " + IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)_this.getRemovedLinks()).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return DebugInfoMethods.toEntityDebugInfo(it);
                }
            }), (String)"; ")));
            ListSequence.fromList((List)delta).addElement((Object)("LINK+: " + IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)_this.getAddedLinks()).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return DebugInfoMethods.toEntityDebugInfo(it);
                }
            }), (String)"; ")));
        } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.ADD.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("ENTITY+: " + DebugInfoMethods.toEntityDebugInfo(_this.getTarget())));
        } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.REMOVE.get())) {
            ListSequence.fromList((List)delta).addElement((Object)("ENTITY-: " + DebugInfoMethods.toEntityDebugInfo(_this.getTarget())));
        } else if (EntityOperations.equals((Entity)type, (Object)EventTypeImpl.MODIFY_STUB.get())) {
            ListSequence.fromList((List)delta).addElement((Object)"STUB");
        } else {
            ListSequence.fromList((List)delta).addElement((Object)"Obsolete event type");
        }
        return delta;
    }

    private static String toEntityDebugInfo(Entity _this) {
        String result = _this.toIdString();
        if (DnqUtils._instanceOf((Object)_this, (String)"Issue")) {
            result = result + " (" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)_this, (String)"Issue"), (String)"Issue")).getId(DnqUtils.cast((Object)_this, (String)"Issue")) + ((Boolean)PrimitiveAssociationSemantics.get((Entity)DnqUtils.cast((Object)_this, (String)"Issue"), (String)"deleted", Boolean.class, null) != false ? ":deleted)" : ")");
        } else {
            List propNames = _this.getPropertyNames();
            if (propNames.contains("name")) {
                result = result + " (" + _this.getProperty("name") + ")";
            } else if (propNames.contains("versionName")) {
                result = result + " (" + _this.getProperty("versionName") + ")";
            }
        }
        return result;
    }
}

