/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.plugin.EventService;
import jetbrains.youtrack.event.rollback.CorruptedEvent;
import jetbrains.youtrack.event.rollback.DebugInfoMethods;
import jetbrains.youtrack.event.rollback.SingleEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class EntityPropertiesHistorySnapshot {
    protected static Log log = LogFactory.getLog(EntityPropertiesHistorySnapshot.class);
    private final Map<String, Object> properties = MapSequence.fromMap(new HashMap());
    private Entity entity;

    public EntityPropertiesHistorySnapshot(Entity e) {
        this.entity = e;
        for (String prop : ListSequence.fromList((List)this.entity.getPropertyNames())) {
            if (!((EventService)ServiceLocator.getBean((String)"eventService")).shouldHandleProperty(this.entity, prop)) continue;
            MapSequence.fromMap(this.properties).put((Object)prop, (Object)this.entity.getProperty(prop));
        }
        for (String blob : ListSequence.fromList((List)this.entity.getBlobNames())) {
            if (!((EventService)ServiceLocator.getBean((String)"eventService")).shouldHandleProperty(this.entity, blob)) continue;
            MapSequence.fromMap(this.properties).put((Object)blob, (Object)this.entity.getBlob(blob));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleEvent rollback(Entity pEvent) {
        SingleEvent event2;
        Comparable propertyState = null;
        String prop = (String)PrimitiveAssociationSemantics.get((Entity)pEvent, (String)"memberName", String.class, null);
        try {
            Comparable oldValue;
            Comparable newValue;
            propertyState = newValue = this.getProperty(prop);
            propertyState = oldValue = ((AbstractPersistentEventImpl)DnqUtils.getPersistentClassInstance((Entity)pEvent, (String)"AbstractPersistentEvent")).getOldPropertyValue(propertyState, pEvent);
            event2 = SingleEvent.propertyEventFromAPE(pEvent, prop, oldValue, newValue, null);
        }
        catch (RuntimeException re) {
            event2 = new CorruptedEvent(pEvent);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip corrupted event: " + DebugInfoMethods.toDebugString(event2) + ", " + re.getMessage()));
            }
        }
        finally {
            MapSequence.fromMap(this.properties).put((Object)prop, (Object)propertyState);
        }
        return event2;
    }

    @Nullable
    public Comparable getProperty(String propName) throws RuntimeException {
        Object rawValue = MapSequence.fromMap(this.properties).get((Object)propName);
        Object value = rawValue == null || rawValue instanceof Comparable ? (Comparable)rawValue : SingleEvent.blobToString((InputStream)rawValue);
        return value;
    }

    public Iterable<IMapping<String, Object>> getProperties() {
        return MapSequence.fromMap(this.properties).toListSequence();
    }
}

