/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.dnq.lang.PersistentClassesKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.event.persistent.AbstractChangeHandler;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventImpl;
import jetbrains.youtrack.event.persistent.BeansKt;
import jetbrains.youtrack.event.persistent.XdEventType;
import jetbrains.youtrack.event.rollback.BlobSnapshot;
import jetbrains.youtrack.event.rollback.CorruptedEvent;
import jetbrains.youtrack.event.rollback.EntityExistenceSnapshot;
import jetbrains.youtrack.event.rollback.LinkSnapshot;
import jetbrains.youtrack.event.rollback.PropSnapshot;
import jetbrains.youtrack.event.rollback.Snapshot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/event/rollback/EntitySnapshot;", "Ljetbrains/youtrack/event/rollback/Snapshot;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "componentSnapshots", "", "", "getComponentSnapshots", "()Ljava/util/Map;", "getEntity", "()Ljetbrains/exodus/entitystore/Entity;", "existenceSnapshot", "Ljetbrains/youtrack/event/rollback/EntityExistenceSnapshot;", "getExistenceSnapshot", "()Ljetbrains/youtrack/event/rollback/EntityExistenceSnapshot;", "setExistenceSnapshot", "(Ljetbrains/youtrack/event/rollback/EntityExistenceSnapshot;)V", "secondaryEntitiesSnapshots", "getSecondaryEntitiesSnapshots", "rollback", "Ljetbrains/youtrack/api/events/Event;", "pEvent", "youtrack-events"})
public final class EntitySnapshot
implements Snapshot {
    @NotNull
    private EntityExistenceSnapshot existenceSnapshot;
    @NotNull
    private final Map<String, Snapshot> componentSnapshots;
    @NotNull
    private final Map<Entity, Snapshot> secondaryEntitiesSnapshots;
    @NotNull
    private final Entity entity;

    @NotNull
    public final EntityExistenceSnapshot getExistenceSnapshot() {
        return this.existenceSnapshot;
    }

    public final void setExistenceSnapshot(@NotNull EntityExistenceSnapshot entityExistenceSnapshot) {
        Intrinsics.checkParameterIsNotNull((Object)entityExistenceSnapshot, (String)"<set-?>");
        this.existenceSnapshot = entityExistenceSnapshot;
    }

    @NotNull
    public final Map<String, Snapshot> getComponentSnapshots() {
        return this.componentSnapshots;
    }

    @NotNull
    public final Map<Entity, Snapshot> getSecondaryEntitiesSnapshots() {
        return this.secondaryEntitiesSnapshots;
    }

    @Override
    @NotNull
    public Event rollback(@NotNull Entity pEvent) {
        Snapshot snapshot;
        Snapshot snapshot2;
        Snapshot snapshot3;
        Object value$iv;
        Intrinsics.checkParameterIsNotNull((Object)pEvent, (String)"pEvent");
        AbstractPersistentEventImpl pEventImpl = (AbstractPersistentEventImpl)PersistentClassesKt.asPersistentClass((Entity)pEvent);
        Entity entity = pEventImpl.getTarget(pEvent);
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"pEventImpl.getTarget(pEvent)");
        Entity targetEntity = entity;
        String memberName = (String)((Object)pEvent.getProperty("memberName"));
        Entity typeEntity = pEvent.getLink("type");
        if (Intrinsics.areEqual((Object)targetEntity, (Object)this.entity) ^ true) {
            Snapshot snapshot4;
            Map<Entity, Snapshot> $receiver$iv = this.secondaryEntitiesSnapshots;
            value$iv = $receiver$iv.get(targetEntity);
            if (value$iv == null) {
                EntitySnapshot answer$iv = new EntitySnapshot(targetEntity);
                $receiver$iv.put(targetEntity, answer$iv);
                snapshot4 = answer$iv;
            } else {
                snapshot4 = value$iv;
            }
            snapshot3 = snapshot4;
        } else {
            String key$iv;
            Map<String, Snapshot> $receiver$iv;
            Object value$iv2;
            Entity entity2 = typeEntity;
            if (Intrinsics.areEqual((Object)entity2, (Object)XdEventType.Companion.getADD().getEntity()) || Intrinsics.areEqual((Object)entity2, (Object)XdEventType.Companion.getREMOVE().getEntity())) {
                snapshot3 = this.existenceSnapshot;
            } else if (Intrinsics.areEqual((Object)entity2, (Object)XdEventType.Companion.getMODIFY_PROPERTY().getEntity())) {
                Object object;
                value$iv = this.componentSnapshots;
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv2 = $receiver$iv.get(key$iv = string)) == null) {
                    PropSnapshot propSnapshot;
                    PropSnapshot $receiver = propSnapshot = new PropSnapshot(targetEntity, memberName);
                    $receiver.setValue(null);
                    PropSnapshot answer$iv = propSnapshot;
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                snapshot3 = (Snapshot)object;
            } else if (Intrinsics.areEqual((Object)entity2, (Object)XdEventType.Companion.getMODIFY_LINK().getEntity())) {
                Object object;
                $receiver$iv = this.componentSnapshots;
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((value$iv2 = $receiver$iv.get(key$iv = string)) == null) {
                    LinkSnapshot answer$iv = new LinkSnapshot(targetEntity, memberName);
                    $receiver$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                snapshot3 = (Snapshot)object;
            } else {
                snapshot3 = null;
            }
        }
        if ((snapshot2 = (snapshot = snapshot3)) == null || (snapshot2 = snapshot2.rollback(pEvent)) == null) {
            snapshot2 = new CorruptedEvent(pEvent);
        }
        return snapshot2;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    public EntitySnapshot(@NotNull Entity entity) {
        Snapshot snapshot;
        String string;
        Map<String, Snapshot> map;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entity = entity;
        this.existenceSnapshot = new EntityExistenceSnapshot();
        this.componentSnapshots = new HashMap();
        this.secondaryEntitiesSnapshots = new HashMap();
        AbstractChangeHandler<?> abstractChangeHandler = BeansKt.changeHandler(this.entity);
        if (abstractChangeHandler == null) {
            throw (Throwable)new IllegalStateException("can't find change handler for " + this.entity.getType());
        }
        AbstractChangeHandler<?> handler = abstractChangeHandler;
        List list = this.entity.getPropertyNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entity.propertyNames");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            String propName;
            String string2 = propName = (String)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"propName");
            if (handler.isPropertyIgnored(string2) || handler.isStubChange(propName)) continue;
            map = this.componentSnapshots;
            string = propName;
            snapshot = new PropSnapshot(this.entity, propName);
            map.put(string, snapshot);
        }
        List list2 = this.entity.getBlobNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"entity.blobNames");
        $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            String blobName;
            String string3 = blobName = (String)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"blobName");
            if (handler.isPropertyIgnored(string3) || handler.isStubChange(blobName)) continue;
            map = this.componentSnapshots;
            string = blobName;
            snapshot = new BlobSnapshot(this.entity, blobName);
            map.put(string, snapshot);
        }
    }
}

